/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Arrays;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.document.LatLonShapeQuery;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.geo.Polygon2D;
import org.apache.lucene.index.PointValues;

final class LatLonShapePolygonQuery
extends LatLonShapeQuery {
    final Polygon[] polygons;
    private final Polygon2D poly2D;

    public LatLonShapePolygonQuery(String field, LatLonShape.QueryRelation queryRelation, Polygon ... polygons) {
        super(field, queryRelation);
        if (polygons == null) {
            throw new IllegalArgumentException("polygons must not be null");
        }
        if (polygons.length == 0) {
            throw new IllegalArgumentException("polygons must not be empty");
        }
        for (int i = 0; i < polygons.length; ++i) {
            if (polygons[i] == null) {
                throw new IllegalArgumentException("polygon[" + i + "] must not be null");
            }
            if (!(polygons[i].minLon > polygons[i].maxLon)) continue;
            throw new IllegalArgumentException("LatLonShapePolygonQuery does not currently support querying across dateline.");
        }
        this.polygons = (Polygon[])polygons.clone();
        this.poly2D = Polygon2D.create((Polygon[])polygons);
    }

    @Override
    protected PointValues.Relation relateRangeBBoxToQuery(int minXOffset, int minYOffset, byte[] minTriangle, int maxXOffset, int maxYOffset, byte[] maxTriangle) {
        double minLat = GeoEncodingUtils.decodeLatitude((byte[])minTriangle, (int)minYOffset);
        double minLon = GeoEncodingUtils.decodeLongitude((byte[])minTriangle, (int)minXOffset);
        double maxLat = GeoEncodingUtils.decodeLatitude((byte[])maxTriangle, (int)maxYOffset);
        double maxLon = GeoEncodingUtils.decodeLongitude((byte[])maxTriangle, (int)maxXOffset);
        return this.poly2D.relate(minLat, maxLat, minLon, maxLon);
    }

    @Override
    protected boolean queryMatches(byte[] triangle) {
        double ay = GeoEncodingUtils.decodeLatitude((byte[])triangle, (int)0);
        double ax = GeoEncodingUtils.decodeLongitude((byte[])triangle, (int)4);
        double by = GeoEncodingUtils.decodeLatitude((byte[])triangle, (int)8);
        double bx = GeoEncodingUtils.decodeLongitude((byte[])triangle, (int)12);
        double cy = GeoEncodingUtils.decodeLatitude((byte[])triangle, (int)16);
        double cx = GeoEncodingUtils.decodeLongitude((byte[])triangle, (int)20);
        if (this.queryRelation == LatLonShape.QueryRelation.WITHIN) {
            return this.poly2D.relateTriangle(ax, ay, bx, by, cx, cy) == PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return this.poly2D.relateTriangle(ax, ay, bx, by, cx, cy) != PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        sb.append("Polygon(" + this.polygons[0].toGeoJSON() + ")");
        return sb.toString();
    }

    @Override
    protected boolean equalsTo(Object o) {
        return super.equalsTo(o) && Arrays.equals(this.polygons, ((LatLonShapePolygonQuery)((Object)o)).polygons);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Arrays.hashCode(this.polygons);
        return hash;
    }
}

