/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.client.methods.HttpAsyncMethods;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.protocol.HttpContext;
import org.elasticsearch.client.DeadHostState;
import org.elasticsearch.client.HttpAsyncResponseConsumerFactory;
import org.elasticsearch.client.HttpDeleteWithEntity;
import org.elasticsearch.client.HttpGetWithEntity;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.NodeSelector;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestLogger;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClientBuilder;

public class RestClient
implements Closeable {
    private static final Log logger = LogFactory.getLog(RestClient.class);
    private final CloseableHttpAsyncClient client;
    final List<Header> defaultHeaders;
    private final long maxRetryTimeoutMillis;
    private final String pathPrefix;
    private final AtomicInteger lastNodeIndex = new AtomicInteger(0);
    private final ConcurrentMap<HttpHost, DeadHostState> blacklist = new ConcurrentHashMap<HttpHost, DeadHostState>();
    private final FailureListener failureListener;
    private final NodeSelector nodeSelector;
    private volatile NodeTuple<List<Node>> nodeTuple;
    private final boolean strictDeprecationMode;

    RestClient(CloseableHttpAsyncClient client, long maxRetryTimeoutMillis, Header[] defaultHeaders, List<Node> nodes, String pathPrefix, FailureListener failureListener, NodeSelector nodeSelector, boolean strictDeprecationMode) {
        this.client = client;
        this.maxRetryTimeoutMillis = maxRetryTimeoutMillis;
        this.defaultHeaders = Collections.unmodifiableList(Arrays.asList(defaultHeaders));
        this.failureListener = failureListener;
        this.pathPrefix = pathPrefix;
        this.nodeSelector = nodeSelector;
        this.strictDeprecationMode = strictDeprecationMode;
        this.setNodes(nodes);
    }

    public static RestClientBuilder builder(Node ... nodes) {
        return new RestClientBuilder(nodes == null ? null : Arrays.asList(nodes));
    }

    public static RestClientBuilder builder(HttpHost ... hosts) {
        return new RestClientBuilder(RestClient.hostsToNodes(hosts));
    }

    @Deprecated
    public void setHosts(HttpHost ... hosts) {
        this.setNodes(RestClient.hostsToNodes(hosts));
    }

    public synchronized void setNodes(Collection<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes must not be null or empty");
        }
        BasicAuthCache authCache = new BasicAuthCache();
        LinkedHashMap<HttpHost, Node> nodesByHost = new LinkedHashMap<HttpHost, Node>();
        for (Node node : nodes) {
            Objects.requireNonNull(node, "node cannot be null");
            nodesByHost.put(node.getHost(), node);
            authCache.put(node.getHost(), (AuthScheme)new BasicScheme());
        }
        this.nodeTuple = new NodeTuple(Collections.unmodifiableList(new ArrayList(nodesByHost.values())), (AuthCache)authCache);
        this.blacklist.clear();
    }

    private static List<Node> hostsToNodes(HttpHost[] hosts) {
        if (hosts == null || hosts.length == 0) {
            throw new IllegalArgumentException("hosts must not be null nor empty");
        }
        ArrayList<Node> nodes = new ArrayList<Node>(hosts.length);
        for (HttpHost host : hosts) {
            nodes.add(new Node(host));
        }
        return nodes;
    }

    public List<Node> getNodes() {
        return (List)this.nodeTuple.nodes;
    }

    public Response performRequest(Request request) throws IOException {
        SyncResponseListener listener = new SyncResponseListener(this.maxRetryTimeoutMillis);
        this.performRequestAsyncNoCatch(request, listener);
        return listener.get();
    }

    public void performRequestAsync(Request request, ResponseListener responseListener) {
        try {
            this.performRequestAsyncNoCatch(request, responseListener);
        }
        catch (Exception e) {
            responseListener.onFailure(e);
        }
    }

    @Deprecated
    public Response performRequest(String method, String endpoint, Header ... headers) throws IOException {
        Request request = new Request(method, endpoint);
        RestClient.addHeaders(request, headers);
        return this.performRequest(request);
    }

    @Deprecated
    public Response performRequest(String method, String endpoint, Map<String, String> params, Header ... headers) throws IOException {
        Request request = new Request(method, endpoint);
        RestClient.addParameters(request, params);
        RestClient.addHeaders(request, headers);
        return this.performRequest(request);
    }

    @Deprecated
    public Response performRequest(String method, String endpoint, Map<String, String> params, HttpEntity entity, Header ... headers) throws IOException {
        Request request = new Request(method, endpoint);
        RestClient.addParameters(request, params);
        request.setEntity(entity);
        RestClient.addHeaders(request, headers);
        return this.performRequest(request);
    }

    @Deprecated
    public Response performRequest(String method, String endpoint, Map<String, String> params, HttpEntity entity, HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory, Header ... headers) throws IOException {
        Request request = new Request(method, endpoint);
        RestClient.addParameters(request, params);
        request.setEntity(entity);
        RestClient.setOptions(request, httpAsyncResponseConsumerFactory, headers);
        return this.performRequest(request);
    }

    @Deprecated
    public void performRequestAsync(String method, String endpoint, ResponseListener responseListener, Header ... headers) {
        Request request;
        try {
            request = new Request(method, endpoint);
            RestClient.addHeaders(request, headers);
        }
        catch (Exception e) {
            responseListener.onFailure(e);
            return;
        }
        this.performRequestAsync(request, responseListener);
    }

    @Deprecated
    public void performRequestAsync(String method, String endpoint, Map<String, String> params, ResponseListener responseListener, Header ... headers) {
        Request request;
        try {
            request = new Request(method, endpoint);
            RestClient.addParameters(request, params);
            RestClient.addHeaders(request, headers);
        }
        catch (Exception e) {
            responseListener.onFailure(e);
            return;
        }
        this.performRequestAsync(request, responseListener);
    }

    @Deprecated
    public void performRequestAsync(String method, String endpoint, Map<String, String> params, HttpEntity entity, ResponseListener responseListener, Header ... headers) {
        Request request;
        try {
            request = new Request(method, endpoint);
            RestClient.addParameters(request, params);
            request.setEntity(entity);
            RestClient.addHeaders(request, headers);
        }
        catch (Exception e) {
            responseListener.onFailure(e);
            return;
        }
        this.performRequestAsync(request, responseListener);
    }

    @Deprecated
    public void performRequestAsync(String method, String endpoint, Map<String, String> params, HttpEntity entity, HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory, ResponseListener responseListener, Header ... headers) {
        Request request;
        try {
            request = new Request(method, endpoint);
            RestClient.addParameters(request, params);
            request.setEntity(entity);
            RestClient.setOptions(request, httpAsyncResponseConsumerFactory, headers);
        }
        catch (Exception e) {
            responseListener.onFailure(e);
            return;
        }
        this.performRequestAsync(request, responseListener);
    }

    void performRequestAsyncNoCatch(Request request, ResponseListener listener) throws IOException {
        Set<Object> ignoreErrorCodes;
        HashMap<String, String> requestParams = new HashMap<String, String>(request.getParameters());
        String ignoreString = (String)requestParams.remove("ignore");
        if (ignoreString == null) {
            ignoreErrorCodes = "HEAD".equals(request.getMethod()) ? Collections.singleton(404) : Collections.emptySet();
        } else {
            String[] ignoresArray = ignoreString.split(",");
            ignoreErrorCodes = new HashSet();
            if ("HEAD".equals(request.getMethod())) {
                ignoreErrorCodes.add(404);
            }
            for (String ignoreCode : ignoresArray) {
                try {
                    ignoreErrorCodes.add(Integer.valueOf(ignoreCode));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("ignore value should be a number, found [" + ignoreString + "] instead", e);
                }
            }
        }
        URI uri = RestClient.buildUri(this.pathPrefix, request.getEndpoint(), requestParams);
        HttpRequestBase httpRequest = RestClient.createHttpRequest(request.getMethod(), uri, request.getEntity());
        this.setHeaders((HttpRequest)httpRequest, request.getOptions().getHeaders());
        FailureTrackingResponseListener failureTrackingResponseListener = new FailureTrackingResponseListener(listener);
        long startTime = System.nanoTime();
        this.performRequestAsync(startTime, this.nextNode(), httpRequest, ignoreErrorCodes, request.getOptions().getHttpAsyncResponseConsumerFactory(), failureTrackingResponseListener);
    }

    private void performRequestAsync(final long startTime, final NodeTuple<Iterator<Node>> nodeTuple, final HttpRequestBase request, final Set<Integer> ignoreErrorCodes, final HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory, final FailureTrackingResponseListener listener) {
        final Node node = (Node)((Iterator)nodeTuple.nodes).next();
        HttpAsyncRequestProducer requestProducer = HttpAsyncMethods.create((HttpHost)node.getHost(), (HttpRequest)request);
        HttpAsyncResponseConsumer<HttpResponse> asyncResponseConsumer = httpAsyncResponseConsumerFactory.createHttpAsyncResponseConsumer();
        HttpClientContext context = HttpClientContext.create();
        context.setAuthCache(nodeTuple.authCache);
        this.client.execute(requestProducer, asyncResponseConsumer, (HttpContext)context, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse httpResponse) {
                try {
                    RequestLogger.logResponse(logger, (HttpUriRequest)request, node.getHost(), httpResponse);
                    int statusCode = httpResponse.getStatusLine().getStatusCode();
                    Response response = new Response(request.getRequestLine(), node.getHost(), httpResponse);
                    if (RestClient.isSuccessfulResponse(statusCode) || ignoreErrorCodes.contains(response.getStatusLine().getStatusCode())) {
                        RestClient.this.onResponse(node);
                        if (RestClient.this.strictDeprecationMode && response.hasWarnings()) {
                            listener.onDefinitiveFailure(new ResponseException(response));
                        } else {
                            listener.onSuccess(response);
                        }
                    } else {
                        ResponseException responseException = new ResponseException(response);
                        if (RestClient.isRetryStatus(statusCode)) {
                            RestClient.this.onFailure(node);
                            this.retryIfPossible(responseException);
                        } else {
                            RestClient.this.onResponse(node);
                            listener.onDefinitiveFailure(responseException);
                        }
                    }
                }
                catch (Exception e) {
                    listener.onDefinitiveFailure(e);
                }
            }

            public void failed(Exception failure) {
                try {
                    RequestLogger.logFailedRequest(logger, (HttpUriRequest)request, node, failure);
                    RestClient.this.onFailure(node);
                    this.retryIfPossible(failure);
                }
                catch (Exception e) {
                    listener.onDefinitiveFailure(e);
                }
            }

            private void retryIfPossible(Exception exception) {
                if (((Iterator)nodeTuple.nodes).hasNext()) {
                    long timeElapsedMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
                    long timeout = RestClient.this.maxRetryTimeoutMillis - timeElapsedMillis;
                    if (timeout <= 0L) {
                        IOException retryTimeoutException = new IOException("request retries exceeded max retry timeout [" + RestClient.this.maxRetryTimeoutMillis + "]");
                        listener.onDefinitiveFailure(retryTimeoutException);
                    } else {
                        listener.trackFailure(exception);
                        request.reset();
                        RestClient.this.performRequestAsync(startTime, nodeTuple, request, ignoreErrorCodes, httpAsyncResponseConsumerFactory, listener);
                    }
                } else {
                    listener.onDefinitiveFailure(exception);
                }
            }

            public void cancelled() {
                listener.onDefinitiveFailure(new ExecutionException("request was cancelled", null));
            }
        });
    }

    private void setHeaders(HttpRequest httpRequest, Collection<Header> requestHeaders) {
        HashSet<String> requestNames = new HashSet<String>(requestHeaders.size());
        for (Header requestHeader : requestHeaders) {
            httpRequest.addHeader(requestHeader);
            requestNames.add(requestHeader.getName());
        }
        for (Header defaultHeader : this.defaultHeaders) {
            if (requestNames.contains(defaultHeader.getName())) continue;
            httpRequest.addHeader(defaultHeader);
        }
    }

    private NodeTuple<Iterator<Node>> nextNode() throws IOException {
        NodeTuple<List<Node>> nodeTuple = this.nodeTuple;
        Iterable<Node> hosts = RestClient.selectNodes(nodeTuple, this.blacklist, this.lastNodeIndex, this.nodeSelector);
        return new NodeTuple<Iterator<Node>>(hosts.iterator(), nodeTuple.authCache);
    }

    static Iterable<Node> selectNodes(NodeTuple<List<Node>> nodeTuple, Map<HttpHost, DeadHostState> blacklist, AtomicInteger lastNodeIndex, NodeSelector nodeSelector) throws IOException {
        ArrayList<Node> livingNodes = new ArrayList<Node>(((List)nodeTuple.nodes).size() - blacklist.size());
        ArrayList<DeadNode> deadNodes = new ArrayList<DeadNode>(blacklist.size());
        for (Node node : (List)nodeTuple.nodes) {
            DeadHostState deadness = blacklist.get(node.getHost());
            if (deadness == null) {
                livingNodes.add(node);
                continue;
            }
            if (deadness.shallBeRetried()) {
                livingNodes.add(node);
                continue;
            }
            deadNodes.add(new DeadNode(node, deadness));
        }
        if (!livingNodes.isEmpty()) {
            ArrayList<Node> selectedLivingNodes = new ArrayList<Node>(livingNodes);
            nodeSelector.select(selectedLivingNodes);
            if (!selectedLivingNodes.isEmpty()) {
                Collections.rotate(selectedLivingNodes, lastNodeIndex.getAndIncrement());
                return selectedLivingNodes;
            }
        }
        if (!deadNodes.isEmpty()) {
            final ArrayList selectedDeadNodes = new ArrayList(deadNodes);
            nodeSelector.select(new Iterable<Node>(){

                @Override
                public Iterator<Node> iterator() {
                    return new DeadNodeIteratorAdapter(selectedDeadNodes.iterator());
                }
            });
            if (!selectedDeadNodes.isEmpty()) {
                return Collections.singletonList(((DeadNode)Collections.min(selectedDeadNodes)).node);
            }
        }
        throw new IOException("NodeSelector [" + nodeSelector + "] rejected all nodes, living " + livingNodes + " and dead " + deadNodes);
    }

    private void onResponse(Node node) {
        DeadHostState removedHost = (DeadHostState)this.blacklist.remove(node.getHost());
        if (logger.isDebugEnabled() && removedHost != null) {
            logger.debug((Object)("removed [" + node + "] from blacklist"));
        }
    }

    private void onFailure(Node node) {
        block3: {
            DeadHostState previousDeadHostState;
            do {
                if ((previousDeadHostState = this.blacklist.putIfAbsent(node.getHost(), new DeadHostState(DeadHostState.TimeSupplier.DEFAULT))) != null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("added [" + node + "] to blacklist"));
                }
                break block3;
            } while (!this.blacklist.replace(node.getHost(), previousDeadHostState, new DeadHostState(previousDeadHostState)));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updated [" + node + "] already in blacklist"));
            }
        }
        this.failureListener.onFailure(node);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private static boolean isSuccessfulResponse(int statusCode) {
        return statusCode < 300;
    }

    private static boolean isRetryStatus(int statusCode) {
        switch (statusCode) {
            case 502: 
            case 503: 
            case 504: {
                return true;
            }
        }
        return false;
    }

    private static Exception addSuppressedException(Exception suppressedException, Exception currentException) {
        if (suppressedException != null) {
            currentException.addSuppressed(suppressedException);
        }
        return currentException;
    }

    private static HttpRequestBase createHttpRequest(String method, URI uri, HttpEntity entity) {
        switch (method.toUpperCase(Locale.ROOT)) {
            case "DELETE": {
                return RestClient.addRequestBody((HttpRequestBase)new HttpDeleteWithEntity(uri), entity);
            }
            case "GET": {
                return RestClient.addRequestBody((HttpRequestBase)new HttpGetWithEntity(uri), entity);
            }
            case "HEAD": {
                return RestClient.addRequestBody((HttpRequestBase)new HttpHead(uri), entity);
            }
            case "OPTIONS": {
                return RestClient.addRequestBody((HttpRequestBase)new HttpOptions(uri), entity);
            }
            case "PATCH": {
                return RestClient.addRequestBody((HttpRequestBase)new HttpPatch(uri), entity);
            }
            case "POST": {
                HttpPost httpPost = new HttpPost(uri);
                RestClient.addRequestBody((HttpRequestBase)httpPost, entity);
                return httpPost;
            }
            case "PUT": {
                return RestClient.addRequestBody((HttpRequestBase)new HttpPut(uri), entity);
            }
            case "TRACE": {
                return RestClient.addRequestBody((HttpRequestBase)new HttpTrace(uri), entity);
            }
        }
        throw new UnsupportedOperationException("http method not supported: " + method);
    }

    private static HttpRequestBase addRequestBody(HttpRequestBase httpRequest, HttpEntity entity) {
        if (entity != null) {
            if (httpRequest instanceof HttpEntityEnclosingRequestBase) {
                ((HttpEntityEnclosingRequestBase)httpRequest).setEntity(entity);
            } else {
                throw new UnsupportedOperationException(httpRequest.getMethod() + " with body is not supported");
            }
        }
        return httpRequest;
    }

    static URI buildUri(String pathPrefix, String path, Map<String, String> params) {
        Objects.requireNonNull(path, "path must not be null");
        try {
            String fullPath = pathPrefix != null && !pathPrefix.isEmpty() ? (pathPrefix.endsWith("/") && path.startsWith("/") ? pathPrefix.substring(0, pathPrefix.length() - 1) + path : (pathPrefix.endsWith("/") || path.startsWith("/") ? pathPrefix + path : pathPrefix + "/" + path)) : path;
            URIBuilder uriBuilder = new URIBuilder(fullPath);
            for (Map.Entry<String, String> param : params.entrySet()) {
                uriBuilder.addParameter(param.getKey(), param.getValue());
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Deprecated
    private static void addHeaders(Request request, Header ... headers) {
        RestClient.setOptions(request, RequestOptions.DEFAULT.getHttpAsyncResponseConsumerFactory(), headers);
    }

    @Deprecated
    private static void setOptions(Request request, HttpAsyncResponseConsumerFactory httpAsyncResponseConsumerFactory, Header ... headers) {
        Objects.requireNonNull(headers, "headers cannot be null");
        RequestOptions.Builder options = request.getOptions().toBuilder();
        for (Header header : headers) {
            Objects.requireNonNull(header, "header cannot be null");
            options.addHeader(header.getName(), header.getValue());
        }
        options.setHttpAsyncResponseConsumerFactory(httpAsyncResponseConsumerFactory);
        request.setOptions(options);
    }

    @Deprecated
    private static void addParameters(Request request, Map<String, String> parameters) {
        Objects.requireNonNull(parameters, "parameters cannot be null");
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
    }

    private static class DeadNodeIteratorAdapter
    implements Iterator<Node> {
        private final Iterator<DeadNode> itr;

        private DeadNodeIteratorAdapter(Iterator<DeadNode> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Node next() {
            return this.itr.next().node;
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    private static class DeadNode
    implements Comparable<DeadNode> {
        final Node node;
        final DeadHostState deadness;

        DeadNode(Node node, DeadHostState deadness) {
            this.node = node;
            this.deadness = deadness;
        }

        public String toString() {
            return this.node.toString();
        }

        @Override
        public int compareTo(DeadNode rhs) {
            return this.deadness.compareTo(rhs.deadness);
        }
    }

    static class NodeTuple<T> {
        final T nodes;
        final AuthCache authCache;

        NodeTuple(T nodes, AuthCache authCache) {
            this.nodes = nodes;
            this.authCache = authCache;
        }
    }

    public static class FailureListener {
        public void onFailure(Node node) {
        }
    }

    static class SyncResponseListener
    implements ResponseListener {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final AtomicReference<Response> response = new AtomicReference();
        private final AtomicReference<Exception> exception = new AtomicReference();
        private final long timeout;

        SyncResponseListener(long timeout) {
            assert (timeout > 0L);
            this.timeout = timeout;
        }

        @Override
        public void onSuccess(Response response) {
            Objects.requireNonNull(response, "response must not be null");
            boolean wasResponseNull = this.response.compareAndSet(null, response);
            if (!wasResponseNull) {
                throw new IllegalStateException("response is already set");
            }
            this.latch.countDown();
        }

        @Override
        public void onFailure(Exception exception) {
            Objects.requireNonNull(exception, "exception must not be null");
            boolean wasExceptionNull = this.exception.compareAndSet(null, exception);
            if (!wasExceptionNull) {
                throw new IllegalStateException("exception is already set");
            }
            this.latch.countDown();
        }

        Response get() throws IOException {
            try {
                if (!this.latch.await(this.timeout, TimeUnit.MILLISECONDS)) {
                    throw new IOException("listener timeout after waiting for [" + this.timeout + "] ms");
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("thread waiting for the response was interrupted", e);
            }
            Exception exception = this.exception.get();
            Response response = this.response.get();
            if (exception != null) {
                if (response != null) {
                    IllegalStateException e = new IllegalStateException("response and exception are unexpectedly set at the same time");
                    e.addSuppressed(exception);
                    throw e;
                }
                if (exception instanceof ResponseException) {
                    throw new ResponseException((ResponseException)exception);
                }
                if (exception instanceof ConnectTimeoutException) {
                    ConnectTimeoutException e = new ConnectTimeoutException(exception.getMessage());
                    e.initCause((Throwable)exception);
                    throw e;
                }
                if (exception instanceof SocketTimeoutException) {
                    SocketTimeoutException e = new SocketTimeoutException(exception.getMessage());
                    e.initCause(exception);
                    throw e;
                }
                if (exception instanceof ConnectionClosedException) {
                    ConnectionClosedException e = new ConnectionClosedException(exception.getMessage());
                    e.initCause((Throwable)exception);
                    throw e;
                }
                if (exception instanceof SSLHandshakeException) {
                    SSLHandshakeException e = new SSLHandshakeException(exception.getMessage());
                    e.initCause(exception);
                    throw e;
                }
                if (exception instanceof ConnectException) {
                    ConnectException e = new ConnectException(exception.getMessage());
                    e.initCause(exception);
                    throw e;
                }
                if (exception instanceof IOException) {
                    throw new IOException(exception.getMessage(), exception);
                }
                if (exception instanceof RuntimeException) {
                    throw new RuntimeException(exception.getMessage(), exception);
                }
                throw new RuntimeException("error while performing request", exception);
            }
            if (response == null) {
                throw new IllegalStateException("response not set and no exception caught either");
            }
            return response;
        }
    }

    static class FailureTrackingResponseListener {
        private final ResponseListener responseListener;
        private volatile Exception exception;

        FailureTrackingResponseListener(ResponseListener responseListener) {
            this.responseListener = responseListener;
        }

        void onSuccess(Response response) {
            this.responseListener.onSuccess(response);
        }

        void onDefinitiveFailure(Exception exception) {
            this.trackFailure(exception);
            this.responseListener.onFailure(this.exception);
        }

        void trackFailure(Exception exception) {
            this.exception = RestClient.addSuppressedException(this.exception, exception);
        }
    }
}

