/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.expressions.js.JavascriptCompiler;
import org.apache.lucene.expressions.js.VariableContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.DoubleConstValueSource;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.script.BucketAggregationScript;
import org.elasticsearch.script.BucketAggregationSelectorScript;
import org.elasticsearch.script.ClassPermission;
import org.elasticsearch.script.FilterScript;
import org.elasticsearch.script.ScoreScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.expression.DateField;
import org.elasticsearch.script.expression.DateObject;
import org.elasticsearch.script.expression.ExpressionSearchScript;
import org.elasticsearch.script.expression.GeoField;
import org.elasticsearch.script.expression.NumericField;
import org.elasticsearch.script.expression.ReplaceableConstDoubleValueSource;
import org.elasticsearch.script.expression.ReplaceableConstDoubleValues;
import org.elasticsearch.search.lookup.SearchLookup;

public class ExpressionScriptEngine
extends AbstractComponent
implements ScriptEngine {
    public static final String NAME = "expression";

    public ExpressionScriptEngine(Settings settings) {
        super(settings);
    }

    public String getType() {
        return NAME;
    }

    public <T> T compile(String scriptName, final String scriptSource, ScriptContext<T> context, Map<String, String> params) {
        final SecurityManager sm = System.getSecurityManager();
        SpecialPermission.check();
        Expression expr = AccessController.doPrivileged(new PrivilegedAction<Expression>(){

            @Override
            public Expression run() {
                try {
                    final AccessControlContext engineContext = AccessController.getContext();
                    ClassLoader loader = this.getClass().getClassLoader();
                    if (sm != null) {
                        loader = new ClassLoader(loader){

                            @Override
                            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                                try {
                                    engineContext.checkPermission((Permission)new ClassPermission(name));
                                }
                                catch (SecurityException e) {
                                    throw new ClassNotFoundException(name, e);
                                }
                                return super.loadClass(name, resolve);
                            }
                        };
                    }
                    return JavascriptCompiler.compile((String)scriptSource, (Map)JavascriptCompiler.DEFAULT_FUNCTIONS, (ClassLoader)loader);
                }
                catch (ParseException e) {
                    throw ExpressionScriptEngine.this.convertToScriptException("compile error", scriptSource, scriptSource, e);
                }
            }
        });
        if (context.instanceClazz.equals(SearchScript.class)) {
            SearchScript.Factory factory = (p, lookup) -> this.newSearchScript(expr, lookup, p);
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(BucketAggregationScript.class)) {
            return context.factoryClazz.cast(ExpressionScriptEngine.newBucketAggregationScriptFactory(expr));
        }
        if (context.instanceClazz.equals(BucketAggregationSelectorScript.class)) {
            final BucketAggregationScript.Factory factory = ExpressionScriptEngine.newBucketAggregationScriptFactory(expr);
            BucketAggregationSelectorScript.Factory wrappedFactory = parameters -> new BucketAggregationSelectorScript(parameters){

                public boolean execute() {
                    return factory.newInstance(this.getParams()).execute() == 1.0;
                }
            };
            return context.factoryClazz.cast(wrappedFactory);
        }
        if (context.instanceClazz.equals(FilterScript.class)) {
            FilterScript.Factory factory = (p, lookup) -> this.newFilterScript(expr, lookup, p);
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ScoreScript.class)) {
            ScoreScript.Factory factory = (p, lookup) -> this.newScoreScript(expr, lookup, p);
            return context.factoryClazz.cast(factory);
        }
        throw new IllegalArgumentException("expression engine does not know how to handle script context [" + context.name + "]");
    }

    private static BucketAggregationScript.Factory newBucketAggregationScriptFactory(final Expression expr) {
        return parameters -> {
            final ReplaceableConstDoubleValues[] functionValuesArray = new ReplaceableConstDoubleValues[expr.variables.length];
            final HashMap<String, ReplaceableConstDoubleValues> functionValuesMap = new HashMap<String, ReplaceableConstDoubleValues>();
            for (int i = 0; i < expr.variables.length; ++i) {
                functionValuesArray[i] = new ReplaceableConstDoubleValues();
                functionValuesMap.put(expr.variables[i], functionValuesArray[i]);
            }
            return new BucketAggregationScript(parameters){

                public Double execute() {
                    this.getParams().forEach((name, value) -> {
                        ReplaceableConstDoubleValues placeholder = (ReplaceableConstDoubleValues)((Object)((Object)functionValuesMap.get(name)));
                        if (placeholder == null) {
                            throw new IllegalArgumentException("Error using " + expr + ". The variable [" + name + "] does not exist in the executable expressions script.");
                        }
                        if (!(value instanceof Number)) {
                            throw new IllegalArgumentException("Error using " + expr + ". Executable expressions scripts can only process numbers.  The variable [" + name + "] is not a number.");
                        }
                        placeholder.setValue(((Number)value).doubleValue());
                    });
                    return expr.evaluate((DoubleValues[])functionValuesArray);
                }
            };
        };
    }

    private SearchScript.LeafFactory newSearchScript(Expression expr, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        MapperService mapper = lookup.doc().mapperService();
        SimpleBindings bindings = new SimpleBindings();
        ReplaceableConstDoubleValueSource specialValue = null;
        boolean needsScores = false;
        for (String variable : expr.variables) {
            try {
                ValueSource valueSource;
                MappedFieldType fieldType;
                if (variable.equals("_score")) {
                    bindings.add(new SortField("_score", SortField.Type.SCORE));
                    needsScores = true;
                    continue;
                }
                if (variable.equals("_value")) {
                    specialValue = new ReplaceableConstDoubleValueSource();
                    bindings.add("_value", (DoubleValuesSource)specialValue);
                    continue;
                }
                if (vars != null && vars.containsKey(variable)) {
                    Object value = vars.get(variable);
                    if (value instanceof Number) {
                        bindings.add(variable, new DoubleConstValueSource(((Number)value).doubleValue()).asDoubleValuesSource());
                        continue;
                    }
                    throw new ParseException("Parameter [" + variable + "] must be a numeric type", 0);
                }
                String fieldname = null;
                String methodname = null;
                String variablename = "value";
                boolean dateAccessor = false;
                VariableContext[] parts = VariableContext.parse((String)variable);
                if (!parts[0].text.equals("doc")) {
                    throw new ParseException("Unknown variable [" + parts[0].text + "]", 0);
                }
                if (parts.length < 2 || parts[1].type != VariableContext.Type.STR_INDEX) {
                    throw new ParseException("Variable 'doc' must be used with a specific field like: doc['myfield']", 3);
                }
                fieldname = parts[1].text;
                if (parts.length == 3) {
                    if (parts[2].type == VariableContext.Type.METHOD) {
                        methodname = parts[2].text;
                    } else if (parts[2].type == VariableContext.Type.MEMBER) {
                        variablename = parts[2].text;
                    } else {
                        throw new IllegalArgumentException("Only member variables or member methods may be accessed on a field when not accessing the field directly");
                    }
                }
                if (parts.length > 3) {
                    if (parts.length == 4 && ("date".equals(parts[2].text) || "getDate".equals(parts[2].text))) {
                        if (parts[3].type == VariableContext.Type.METHOD) {
                            methodname = parts[3].text;
                            dateAccessor = true;
                        } else if (parts[3].type == VariableContext.Type.MEMBER) {
                            variablename = parts[3].text;
                            dateAccessor = true;
                        }
                    }
                    if (!dateAccessor) {
                        throw new IllegalArgumentException("Variable [" + variable + "] does not follow an allowed format of either doc['field'] or doc['field'].method()");
                    }
                }
                if ((fieldType = mapper.fullName(fieldname)) == null) {
                    throw new ParseException("Field [" + fieldname + "] does not exist in mappings", 5);
                }
                IndexFieldData fieldData = lookup.doc().getForField(fieldType);
                if (fieldType instanceof GeoPointFieldMapper.GeoPointFieldType) {
                    valueSource = methodname == null ? GeoField.getVariable(fieldData, fieldname, variablename) : GeoField.getMethod(fieldData, fieldname, methodname);
                } else if (fieldType instanceof DateFieldMapper.DateFieldType) {
                    valueSource = dateAccessor ? (methodname == null ? DateObject.getVariable(fieldData, fieldname, variablename) : DateObject.getMethod(fieldData, fieldname, methodname)) : (methodname == null ? DateField.getVariable(fieldData, fieldname, variablename) : DateField.getMethod(fieldData, fieldname, methodname));
                } else if (fieldData instanceof IndexNumericFieldData) {
                    valueSource = methodname == null ? NumericField.getVariable(fieldData, fieldname, variablename) : NumericField.getMethod(fieldData, fieldname, methodname);
                } else {
                    throw new ParseException("Field [" + fieldname + "] must be numeric, date, or geopoint", 5);
                }
                needsScores |= valueSource.getSortField(false).needsScores();
                bindings.add(variable, valueSource.asDoubleValuesSource());
            }
            catch (Exception e) {
                throw this.convertToScriptException("link error", expr.sourceText, variable, e);
            }
        }
        return new ExpressionSearchScript(expr, bindings, specialValue, needsScores);
    }

    private FilterScript.LeafFactory newFilterScript(Expression expr, SearchLookup lookup, @Nullable Map<String, Object> vars) {
        SearchScript.LeafFactory searchLeafFactory = this.newSearchScript(expr, lookup, vars);
        return ctx -> {
            final SearchScript script = searchLeafFactory.newInstance(ctx);
            return new FilterScript(vars, lookup, ctx){

                public boolean execute() {
                    return script.runAsDouble() != 0.0;
                }

                public void setDocument(int docid) {
                    script.setDocument(docid);
                }
            };
        };
    }

    private ScoreScript.LeafFactory newScoreScript(Expression expr, final SearchLookup lookup, final @Nullable Map<String, Object> vars) {
        final SearchScript.LeafFactory searchLeafFactory = this.newSearchScript(expr, lookup, vars);
        return new ScoreScript.LeafFactory(){

            public boolean needs_score() {
                return searchLeafFactory.needs_score();
            }

            public ScoreScript newInstance(LeafReaderContext ctx) throws IOException {
                final SearchScript script = searchLeafFactory.newInstance(ctx);
                return new ScoreScript(vars, lookup, ctx){

                    public double execute() {
                        return script.runAsDouble();
                    }

                    public void setDocument(int docid) {
                        script.setDocument(docid);
                    }

                    public void setScorer(Scorer scorer) {
                        script.setScorer(scorer);
                    }

                    public double get_score() {
                        return script.getScore();
                    }
                };
            }
        };
    }

    private ScriptException convertToScriptException(String message, String source, String portion, Throwable cause) {
        ArrayList<String> stack = new ArrayList<String>();
        stack.add(portion);
        StringBuilder pointer = new StringBuilder();
        if (cause instanceof ParseException) {
            int offset = ((ParseException)cause).getErrorOffset();
            for (int i = 0; i < offset; ++i) {
                pointer.append(' ');
            }
        }
        pointer.append("^---- HERE");
        stack.add(pointer.toString());
        throw new ScriptException(message, cause, stack, source, NAME);
    }
}

