/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.lookup;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.painless.lookup.def;

public final class PainlessLookupUtility {
    public static final String DEF_CLASS_NAME = "def";
    public static final String CONSTRUCTOR_NAME = "<init>";

    public static Class<?> canonicalTypeNameToType(String canonicalTypeName, Map<String, Class<?>> canonicalClassNamesToClasses) {
        Objects.requireNonNull(canonicalTypeName);
        Objects.requireNonNull(canonicalClassNamesToClasses);
        Class<?> type = canonicalClassNamesToClasses.get(canonicalTypeName);
        if (type != null) {
            return type;
        }
        int arrayDimensions = 0;
        int arrayIndex = canonicalTypeName.indexOf(91);
        if (arrayIndex != -1) {
            int typeNameLength = canonicalTypeName.length();
            while (arrayIndex < typeNameLength) {
                if (canonicalTypeName.charAt(arrayIndex) == '[' && ++arrayIndex < typeNameLength && canonicalTypeName.charAt(arrayIndex++) == ']') {
                    ++arrayDimensions;
                    continue;
                }
                throw new IllegalArgumentException("type [" + canonicalTypeName + "] not found");
            }
            canonicalTypeName = canonicalTypeName.substring(0, canonicalTypeName.indexOf(91));
            type = canonicalClassNamesToClasses.get(canonicalTypeName);
            char[] arrayBraces = new char[arrayDimensions];
            Arrays.fill(arrayBraces, '[');
            String javaTypeName = new String(arrayBraces);
            javaTypeName = type == Boolean.TYPE ? javaTypeName + "Z" : (type == Byte.TYPE ? javaTypeName + "B" : (type == Short.TYPE ? javaTypeName + "S" : (type == Character.TYPE ? javaTypeName + "C" : (type == Integer.TYPE ? javaTypeName + "I" : (type == Long.TYPE ? javaTypeName + "J" : (type == Float.TYPE ? javaTypeName + "F" : (type == Double.TYPE ? javaTypeName + "D" : javaTypeName + "L" + type.getName() + ";")))))));
            try {
                return Class.forName(javaTypeName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException("type [" + canonicalTypeName + "] not found", cnfe);
            }
        }
        throw new IllegalArgumentException("type [" + canonicalTypeName + "] not found");
    }

    public static String typeToCanonicalTypeName(Class<?> type) {
        Objects.requireNonNull(type);
        String canonicalTypeName = type.getCanonicalName();
        if (canonicalTypeName.startsWith(def.class.getCanonicalName())) {
            canonicalTypeName = canonicalTypeName.replace(def.class.getCanonicalName(), DEF_CLASS_NAME);
        }
        return canonicalTypeName;
    }

    public static String typesToCanonicalTypeNames(List<Class<?>> types) {
        StringBuilder typesStringBuilder = new StringBuilder("[");
        int anyTypesSize = types.size();
        int anyTypesIndex = 0;
        for (Class<?> painlessType : types) {
            String canonicalTypeName = PainlessLookupUtility.typeToCanonicalTypeName(painlessType);
            typesStringBuilder.append(canonicalTypeName);
            if (++anyTypesIndex >= anyTypesSize) continue;
            typesStringBuilder.append(",");
        }
        typesStringBuilder.append("]");
        return typesStringBuilder.toString();
    }

    public static Class<?> javaTypeToType(Class<?> javaType) {
        Objects.requireNonNull(javaType);
        if (javaType.isArray()) {
            Class<?> javaTypeComponent = javaType.getComponentType();
            int arrayDimensions = 1;
            while (javaTypeComponent.isArray()) {
                javaTypeComponent = javaTypeComponent.getComponentType();
                ++arrayDimensions;
            }
            if (javaTypeComponent == Object.class) {
                char[] arrayBraces = new char[arrayDimensions];
                Arrays.fill(arrayBraces, '[');
                try {
                    return Class.forName(new String(arrayBraces) + "L" + def.class.getName() + ";");
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalStateException("internal error", cnfe);
                }
            }
        } else if (javaType == Object.class) {
            return def.class;
        }
        return javaType;
    }

    public static Class<?> typeToJavaType(Class<?> type) {
        Objects.requireNonNull(type);
        if (type.isArray()) {
            Class<?> typeComponent = type.getComponentType();
            int arrayDimensions = 1;
            while (typeComponent.isArray()) {
                typeComponent = typeComponent.getComponentType();
                ++arrayDimensions;
            }
            if (typeComponent == def.class) {
                char[] arrayBraces = new char[arrayDimensions];
                Arrays.fill(arrayBraces, '[');
                try {
                    return Class.forName(new String(arrayBraces) + "L" + Object.class.getName() + ";");
                }
                catch (ClassNotFoundException cnfe) {
                    throw new IllegalStateException("internal error", cnfe);
                }
            }
        } else if (type == def.class) {
            return Object.class;
        }
        return type;
    }

    public static void validateType(Class<?> type, Collection<Class<?>> classes) {
        String canonicalTypeName = PainlessLookupUtility.typeToCanonicalTypeName(type);
        while (type.getComponentType() != null) {
            type = type.getComponentType();
        }
        if (!classes.contains(type)) {
            throw new IllegalArgumentException("type [" + canonicalTypeName + "] not found");
        }
    }

    public static Class<?> typeToBoxedType(Class<?> type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        return type;
    }

    public static Class<?> typeToUnboxedType(Class<?> type) {
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        return type;
    }

    public static boolean isConstantType(Class<?> type) {
        return type == Boolean.TYPE || type == Byte.TYPE || type == Short.TYPE || type == Character.TYPE || type == Integer.TYPE || type == Long.TYPE || type == Float.TYPE || type == Double.TYPE || type == String.class;
    }

    public static String buildPainlessMethodKey(String methodName, int methodArity) {
        return methodName + "/" + methodArity;
    }

    public static String buildPainlessFieldKey(String fieldName) {
        return fieldName;
    }

    private PainlessLookupUtility() {
    }
}

