/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.MergePolicy;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.MergePolicyConfig;
import org.elasticsearch.index.MergeSchedulerConfig;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.node.Node;

public final class IndexSettings {
    public static final String DEFAULT_FIELD_SETTING_KEY = "index.query.default_field";
    public static final Setting<List<String>> DEFAULT_FIELD_SETTING;
    public static final Setting<Boolean> QUERY_STRING_LENIENT_SETTING;
    public static final Setting<Boolean> QUERY_STRING_ANALYZE_WILDCARD;
    public static final Setting<Boolean> QUERY_STRING_ALLOW_LEADING_WILDCARD;
    public static final Setting<Boolean> ALLOW_UNMAPPED;
    public static final Setting<TimeValue> INDEX_TRANSLOG_SYNC_INTERVAL_SETTING;
    public static final Setting<Translog.Durability> INDEX_TRANSLOG_DURABILITY_SETTING;
    public static final Setting<Boolean> INDEX_WARMER_ENABLED_SETTING;
    @Deprecated
    public static final Setting<Boolean> INDEX_TTL_DISABLE_PURGE_SETTING;
    public static final Setting<String> INDEX_CHECK_ON_STARTUP;
    public static final Setting<Integer> MAX_RESULT_WINDOW_SETTING;
    public static final Setting<Integer> MAX_SCRIPT_FIELDS_SETTING;
    public static final Setting<Integer> MAX_INNER_RESULT_WINDOW_SETTING;
    public static final Setting<Integer> MAX_ANALYZED_OFFSET_SETTING;
    public static final Setting<Integer> MAX_TERMS_COUNT_SETTING;
    public static final Setting<Integer> MAX_NGRAM_DIFF_SETTING;
    public static final Setting<Integer> MAX_SHINGLE_DIFF_SETTING;
    public static final Setting<Integer> MAX_DOCVALUE_FIELDS_SEARCH_SETTING;
    public static final Setting<Integer> MAX_RESCORE_WINDOW_SETTING;
    public static final Setting<Integer> MAX_ADJACENCY_MATRIX_FILTERS_SETTING;
    public static final TimeValue DEFAULT_REFRESH_INTERVAL;
    public static final Setting<TimeValue> INDEX_REFRESH_INTERVAL_SETTING;
    public static final Setting<ByteSizeValue> INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING;
    public static final Setting<TimeValue> INDEX_TRANSLOG_RETENTION_AGE_SETTING;
    public static final Setting<ByteSizeValue> INDEX_TRANSLOG_RETENTION_SIZE_SETTING;
    public static final Setting<ByteSizeValue> INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING;
    public static final TimeValue DEFAULT_GC_DELETES;
    public static final Setting<TimeValue> INDEX_GC_DELETES_SETTING;
    public static final Setting<Integer> MAX_REFRESH_LISTENERS_PER_SHARD;
    public static final Setting<Integer> MAX_SLICES_PER_SCROLL;
    public static final Setting<Integer> MAX_REGEX_LENGTH_SETTING;
    public static final String INDEX_MAPPING_SINGLE_TYPE_SETTING_KEY = "index.mapping.single_type";
    private static final Setting<Boolean> INDEX_MAPPING_SINGLE_TYPE_SETTING;
    private final Index index;
    private final Version version;
    private final Logger logger;
    private final String nodeName;
    private final Settings nodeSettings;
    private final int numberOfShards;
    private volatile Settings settings;
    private volatile IndexMetaData indexMetaData;
    private volatile List<String> defaultFields;
    private final boolean queryStringLenient;
    private final boolean queryStringAnalyzeWildcard;
    private final boolean queryStringAllowLeadingWildcard;
    private final boolean defaultAllowUnmappedFields;
    private volatile Translog.Durability durability;
    private final TimeValue syncInterval;
    private volatile TimeValue refreshInterval;
    private volatile ByteSizeValue flushThresholdSize;
    private volatile TimeValue translogRetentionAge;
    private volatile ByteSizeValue translogRetentionSize;
    private volatile ByteSizeValue generationThresholdSize;
    private final MergeSchedulerConfig mergeSchedulerConfig;
    private final MergePolicyConfig mergePolicyConfig;
    private final IndexSortConfig indexSortConfig;
    private final IndexScopedSettings scopedSettings;
    private long gcDeletesInMillis = DEFAULT_GC_DELETES.millis();
    private volatile boolean warmerEnabled;
    private volatile int maxResultWindow;
    private volatile int maxInnerResultWindow;
    private volatile int maxAdjacencyMatrixFilters;
    private volatile int maxRescoreWindow;
    private volatile int maxDocvalueFields;
    private volatile int maxScriptFields;
    private volatile int maxNgramDiff;
    private volatile int maxShingleDiff;
    private volatile int maxAnalyzedOffset;
    private volatile int maxTermsCount;
    private volatile int maxRefreshListeners;
    private volatile int maxSlicesPerScroll;
    private volatile int maxRegexLength;
    private final boolean singleType;

    public List<String> getDefaultFields() {
        return this.defaultFields;
    }

    private void setDefaultFields(List<String> defaultFields) {
        this.defaultFields = defaultFields;
    }

    public boolean isQueryStringLenient() {
        return this.queryStringLenient;
    }

    public boolean isQueryStringAnalyzeWildcard() {
        return this.queryStringAnalyzeWildcard;
    }

    public boolean isQueryStringAllowLeadingWildcard() {
        return this.queryStringAllowLeadingWildcard;
    }

    public boolean isDefaultAllowUnmappedFields() {
        return this.defaultAllowUnmappedFields;
    }

    public IndexSettings(IndexMetaData indexMetaData, Settings nodeSettings) {
        this(indexMetaData, nodeSettings, IndexScopedSettings.DEFAULT_SCOPED_SETTINGS);
    }

    public IndexSettings(IndexMetaData indexMetaData, Settings nodeSettings, IndexScopedSettings indexScopedSettings) {
        this.scopedSettings = indexScopedSettings.copy(nodeSettings, indexMetaData);
        this.nodeSettings = nodeSettings;
        this.settings = Settings.builder().put(nodeSettings).put(indexMetaData.getSettings()).build();
        this.index = indexMetaData.getIndex();
        this.version = Version.indexCreated(this.settings);
        this.logger = Loggers.getLogger(this.getClass(), this.settings, this.index, new String[0]);
        this.nodeName = Node.NODE_NAME_SETTING.get(this.settings);
        this.indexMetaData = indexMetaData;
        this.numberOfShards = this.settings.getAsInt("index.number_of_shards", null);
        this.queryStringLenient = QUERY_STRING_LENIENT_SETTING.get(this.settings);
        this.queryStringAnalyzeWildcard = QUERY_STRING_ANALYZE_WILDCARD.get(nodeSettings);
        this.queryStringAllowLeadingWildcard = QUERY_STRING_ALLOW_LEADING_WILDCARD.get(nodeSettings);
        this.defaultAllowUnmappedFields = this.scopedSettings.get(ALLOW_UNMAPPED);
        this.durability = this.scopedSettings.get(INDEX_TRANSLOG_DURABILITY_SETTING);
        this.defaultFields = this.scopedSettings.get(DEFAULT_FIELD_SETTING);
        this.syncInterval = INDEX_TRANSLOG_SYNC_INTERVAL_SETTING.get(this.settings);
        this.refreshInterval = this.scopedSettings.get(INDEX_REFRESH_INTERVAL_SETTING);
        this.flushThresholdSize = this.scopedSettings.get(INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING);
        this.translogRetentionAge = this.scopedSettings.get(INDEX_TRANSLOG_RETENTION_AGE_SETTING);
        this.translogRetentionSize = this.scopedSettings.get(INDEX_TRANSLOG_RETENTION_SIZE_SETTING);
        this.generationThresholdSize = this.scopedSettings.get(INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING);
        this.mergeSchedulerConfig = new MergeSchedulerConfig(this);
        this.gcDeletesInMillis = this.scopedSettings.get(INDEX_GC_DELETES_SETTING).getMillis();
        this.warmerEnabled = this.scopedSettings.get(INDEX_WARMER_ENABLED_SETTING);
        this.maxResultWindow = this.scopedSettings.get(MAX_RESULT_WINDOW_SETTING);
        this.maxInnerResultWindow = this.scopedSettings.get(MAX_INNER_RESULT_WINDOW_SETTING);
        this.maxAdjacencyMatrixFilters = this.scopedSettings.get(MAX_ADJACENCY_MATRIX_FILTERS_SETTING);
        this.maxRescoreWindow = this.scopedSettings.get(MAX_RESCORE_WINDOW_SETTING);
        this.maxDocvalueFields = this.scopedSettings.get(MAX_DOCVALUE_FIELDS_SEARCH_SETTING);
        this.maxScriptFields = this.scopedSettings.get(MAX_SCRIPT_FIELDS_SETTING);
        this.maxNgramDiff = this.scopedSettings.get(MAX_NGRAM_DIFF_SETTING);
        this.maxShingleDiff = this.scopedSettings.get(MAX_SHINGLE_DIFF_SETTING);
        this.maxRefreshListeners = this.scopedSettings.get(MAX_REFRESH_LISTENERS_PER_SHARD);
        this.maxSlicesPerScroll = this.scopedSettings.get(MAX_SLICES_PER_SCROLL);
        this.maxAnalyzedOffset = this.scopedSettings.get(MAX_ANALYZED_OFFSET_SETTING);
        this.maxTermsCount = this.scopedSettings.get(MAX_TERMS_COUNT_SETTING);
        this.maxRegexLength = this.scopedSettings.get(MAX_REGEX_LENGTH_SETTING);
        this.mergePolicyConfig = new MergePolicyConfig(this.logger, this);
        this.indexSortConfig = new IndexSortConfig(this);
        this.singleType = INDEX_MAPPING_SINGLE_TYPE_SETTING.get(indexMetaData.getSettings());
        if (!(this.singleType || this.version.before(Version.V_6_0_0_alpha1))) {
            throw new AssertionError((Object)(this.index.toString() + "multiple types are only allowed on pre 6.x indices but version is: [" + this.version + "]"));
        }
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_COMPOUND_FORMAT_SETTING, this.mergePolicyConfig::setNoCFSRatio);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_EXPUNGE_DELETES_ALLOWED_SETTING, this.mergePolicyConfig::setExpungeDeletesAllowed);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_FLOOR_SEGMENT_SETTING, this.mergePolicyConfig::setFloorSegmentSetting);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_SETTING, this.mergePolicyConfig::setMaxMergesAtOnce);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGE_AT_ONCE_EXPLICIT_SETTING, this.mergePolicyConfig::setMaxMergesAtOnceExplicit);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_MAX_MERGED_SEGMENT_SETTING, this.mergePolicyConfig::setMaxMergedSegment);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_SEGMENTS_PER_TIER_SETTING, this.mergePolicyConfig::setSegmentsPerTier);
        this.scopedSettings.addSettingsUpdateConsumer(MergePolicyConfig.INDEX_MERGE_POLICY_RECLAIM_DELETES_WEIGHT_SETTING, this.mergePolicyConfig::setReclaimDeletesWeight);
        this.scopedSettings.addSettingsUpdateConsumer(MergeSchedulerConfig.MAX_THREAD_COUNT_SETTING, MergeSchedulerConfig.MAX_MERGE_COUNT_SETTING, this.mergeSchedulerConfig::setMaxThreadAndMergeCount);
        this.scopedSettings.addSettingsUpdateConsumer(MergeSchedulerConfig.AUTO_THROTTLE_SETTING, this.mergeSchedulerConfig::setAutoThrottle);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_DURABILITY_SETTING, this::setTranslogDurability);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_RESULT_WINDOW_SETTING, this::setMaxResultWindow);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_INNER_RESULT_WINDOW_SETTING, this::setMaxInnerResultWindow);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_ADJACENCY_MATRIX_FILTERS_SETTING, this::setMaxAdjacencyMatrixFilters);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_RESCORE_WINDOW_SETTING, this::setMaxRescoreWindow);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_DOCVALUE_FIELDS_SEARCH_SETTING, this::setMaxDocvalueFields);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_SCRIPT_FIELDS_SETTING, this::setMaxScriptFields);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_NGRAM_DIFF_SETTING, this::setMaxNgramDiff);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_SHINGLE_DIFF_SETTING, this::setMaxShingleDiff);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_WARMER_ENABLED_SETTING, this::setEnableWarmer);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_GC_DELETES_SETTING, this::setGCDeletes);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING, this::setTranslogFlushThresholdSize);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING, this::setGenerationThresholdSize);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_RETENTION_AGE_SETTING, this::setTranslogRetentionAge);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_TRANSLOG_RETENTION_SIZE_SETTING, this::setTranslogRetentionSize);
        this.scopedSettings.addSettingsUpdateConsumer(INDEX_REFRESH_INTERVAL_SETTING, this::setRefreshInterval);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_REFRESH_LISTENERS_PER_SHARD, this::setMaxRefreshListeners);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_ANALYZED_OFFSET_SETTING, this::setHighlightMaxAnalyzedOffset);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_TERMS_COUNT_SETTING, this::setMaxTermsCount);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_SLICES_PER_SCROLL, this::setMaxSlicesPerScroll);
        this.scopedSettings.addSettingsUpdateConsumer(DEFAULT_FIELD_SETTING, this::setDefaultFields);
        this.scopedSettings.addSettingsUpdateConsumer(MAX_REGEX_LENGTH_SETTING, this::setMaxRegexLength);
    }

    private void setTranslogFlushThresholdSize(ByteSizeValue byteSizeValue) {
        this.flushThresholdSize = byteSizeValue;
    }

    private void setTranslogRetentionSize(ByteSizeValue byteSizeValue) {
        this.translogRetentionSize = byteSizeValue;
    }

    private void setTranslogRetentionAge(TimeValue age) {
        this.translogRetentionAge = age;
    }

    private void setGenerationThresholdSize(ByteSizeValue generationThresholdSize) {
        this.generationThresholdSize = generationThresholdSize;
    }

    private void setGCDeletes(TimeValue timeValue) {
        this.gcDeletesInMillis = timeValue.getMillis();
    }

    private void setRefreshInterval(TimeValue timeValue) {
        this.refreshInterval = timeValue;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public Index getIndex() {
        return this.index;
    }

    public String getUUID() {
        return this.getIndex().getUUID();
    }

    public boolean hasCustomDataPath() {
        return this.customDataPath() != null;
    }

    public String customDataPath() {
        return this.settings.get("index.data_path");
    }

    public Version getIndexVersionCreated() {
        return this.version;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public IndexMetaData getIndexMetaData() {
        return this.indexMetaData;
    }

    public int getNumberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfReplicas() {
        return this.settings.getAsInt("index.number_of_replicas", null);
    }

    public boolean isSingleType() {
        return this.singleType;
    }

    public Settings getNodeSettings() {
        return this.nodeSettings;
    }

    public synchronized boolean updateIndexMetaData(IndexMetaData indexMetaData) {
        Settings newSettings = indexMetaData.getSettings();
        if (!this.version.equals(Version.indexCreated(newSettings))) {
            throw new IllegalArgumentException("version mismatch on settings update expected: " + this.version + " but was: " + Version.indexCreated(newSettings));
        }
        String newUUID = newSettings.get("index.uuid", "_na_");
        if (!newUUID.equals(this.getUUID())) {
            throw new IllegalArgumentException("uuid mismatch on settings update expected: " + this.getUUID() + " but was: " + newUUID);
        }
        this.indexMetaData = indexMetaData;
        Settings existingSettings = this.settings;
        if (existingSettings.filter(IndexScopedSettings.INDEX_SETTINGS_KEY_PREDICATE).equals(newSettings.filter(IndexScopedSettings.INDEX_SETTINGS_KEY_PREDICATE))) {
            return false;
        }
        this.scopedSettings.applySettings(newSettings);
        this.settings = Settings.builder().put(this.nodeSettings).put(newSettings).build();
        return true;
    }

    public Translog.Durability getTranslogDurability() {
        return this.durability;
    }

    private void setTranslogDurability(Translog.Durability durability) {
        this.durability = durability;
    }

    public boolean isWarmerEnabled() {
        return this.warmerEnabled;
    }

    private void setEnableWarmer(boolean enableWarmer) {
        this.warmerEnabled = enableWarmer;
    }

    public TimeValue getTranslogSyncInterval() {
        return this.syncInterval;
    }

    public TimeValue getRefreshInterval() {
        return this.refreshInterval;
    }

    public ByteSizeValue getFlushThresholdSize() {
        return this.flushThresholdSize;
    }

    public ByteSizeValue getTranslogRetentionSize() {
        return this.translogRetentionSize;
    }

    public TimeValue getTranslogRetentionAge() {
        return this.translogRetentionAge;
    }

    public ByteSizeValue getGenerationThresholdSize() {
        return this.generationThresholdSize;
    }

    public MergeSchedulerConfig getMergeSchedulerConfig() {
        return this.mergeSchedulerConfig;
    }

    public int getMaxResultWindow() {
        return this.maxResultWindow;
    }

    private void setMaxResultWindow(int maxResultWindow) {
        this.maxResultWindow = maxResultWindow;
    }

    public int getMaxInnerResultWindow() {
        return this.maxInnerResultWindow;
    }

    private void setMaxInnerResultWindow(int maxInnerResultWindow) {
        this.maxInnerResultWindow = maxInnerResultWindow;
    }

    public int getMaxAdjacencyMatrixFilters() {
        return this.maxAdjacencyMatrixFilters;
    }

    private void setMaxAdjacencyMatrixFilters(int maxAdjacencyFilters) {
        this.maxAdjacencyMatrixFilters = maxAdjacencyFilters;
    }

    public int getMaxRescoreWindow() {
        return this.maxRescoreWindow;
    }

    private void setMaxRescoreWindow(int maxRescoreWindow) {
        this.maxRescoreWindow = maxRescoreWindow;
    }

    public int getMaxDocvalueFields() {
        return this.maxDocvalueFields;
    }

    private void setMaxDocvalueFields(int maxDocvalueFields) {
        this.maxDocvalueFields = maxDocvalueFields;
    }

    public int getMaxNgramDiff() {
        return this.maxNgramDiff;
    }

    private void setMaxNgramDiff(int maxNgramDiff) {
        this.maxNgramDiff = maxNgramDiff;
    }

    public int getMaxShingleDiff() {
        return this.maxShingleDiff;
    }

    private void setMaxShingleDiff(int maxShingleDiff) {
        this.maxShingleDiff = maxShingleDiff;
    }

    public int getHighlightMaxAnalyzedOffset() {
        return this.maxAnalyzedOffset;
    }

    private void setHighlightMaxAnalyzedOffset(int maxAnalyzedOffset) {
        if (maxAnalyzedOffset < 1) {
            throw new IllegalArgumentException("[" + MAX_ANALYZED_OFFSET_SETTING.getKey() + "] must be >= 1");
        }
        this.maxAnalyzedOffset = maxAnalyzedOffset;
    }

    public int getMaxTermsCount() {
        return this.maxTermsCount;
    }

    private void setMaxTermsCount(int maxTermsCount) {
        this.maxTermsCount = maxTermsCount;
    }

    public int getMaxScriptFields() {
        return this.maxScriptFields;
    }

    private void setMaxScriptFields(int maxScriptFields) {
        this.maxScriptFields = maxScriptFields;
    }

    public long getGcDeletesInMillis() {
        return this.gcDeletesInMillis;
    }

    public MergePolicy getMergePolicy() {
        return this.mergePolicyConfig.getMergePolicy();
    }

    public <T> T getValue(Setting<T> setting) {
        return this.scopedSettings.get(setting);
    }

    public int getMaxRefreshListeners() {
        return this.maxRefreshListeners;
    }

    private void setMaxRefreshListeners(int maxRefreshListeners) {
        this.maxRefreshListeners = maxRefreshListeners;
    }

    public int getMaxSlicesPerScroll() {
        return this.maxSlicesPerScroll;
    }

    private void setMaxSlicesPerScroll(int value) {
        this.maxSlicesPerScroll = value;
    }

    public int getMaxRegexLength() {
        return this.maxRegexLength;
    }

    private void setMaxRegexLength(int maxRegexLength) {
        this.maxRegexLength = maxRegexLength;
    }

    public IndexSortConfig getIndexSortConfig() {
        return this.indexSortConfig;
    }

    public IndexScopedSettings getScopedSettings() {
        return this.scopedSettings;
    }

    static {
        Function<Settings, Object> defValue = settings -> {
            String defaultField = settings.getAsVersion("index.version.created", null) != null && Version.indexCreated(settings).before(Version.V_6_0_0_alpha1) ? "_all" : "*";
            return Collections.singletonList(defaultField);
        };
        DEFAULT_FIELD_SETTING = Setting.listSetting(DEFAULT_FIELD_SETTING_KEY, defValue, Function.identity(), Setting.Property.IndexScope, Setting.Property.Dynamic);
        QUERY_STRING_LENIENT_SETTING = Setting.boolSetting("index.query_string.lenient", false, Setting.Property.IndexScope);
        QUERY_STRING_ANALYZE_WILDCARD = Setting.boolSetting("indices.query.query_string.analyze_wildcard", false, Setting.Property.NodeScope);
        QUERY_STRING_ALLOW_LEADING_WILDCARD = Setting.boolSetting("indices.query.query_string.allowLeadingWildcard", true, Setting.Property.NodeScope);
        ALLOW_UNMAPPED = Setting.boolSetting("index.query.parse.allow_unmapped_fields", true, Setting.Property.IndexScope);
        INDEX_TRANSLOG_SYNC_INTERVAL_SETTING = Setting.timeSetting("index.translog.sync_interval", TimeValue.timeValueSeconds((long)5L), TimeValue.timeValueMillis((long)100L), Setting.Property.IndexScope);
        INDEX_TRANSLOG_DURABILITY_SETTING = new Setting<Translog.Durability>("index.translog.durability", Translog.Durability.REQUEST.name(), value -> Translog.Durability.valueOf(value.toUpperCase(Locale.ROOT)), Setting.Property.Dynamic, Setting.Property.IndexScope);
        INDEX_WARMER_ENABLED_SETTING = Setting.boolSetting("index.warmer.enabled", true, Setting.Property.Dynamic, Setting.Property.IndexScope);
        INDEX_TTL_DISABLE_PURGE_SETTING = Setting.boolSetting("index.ttl.disable_purge", false, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.Deprecated);
        INDEX_CHECK_ON_STARTUP = new Setting<String>("index.shard.check_on_startup", "false", s -> {
            switch (s) {
                case "false": 
                case "true": 
                case "fix": 
                case "checksum": {
                    return s;
                }
            }
            throw new IllegalArgumentException("unknown value for [index.shard.check_on_startup] must be one of [true, false, fix, checksum] but was: " + s);
        }, Setting.Property.IndexScope);
        MAX_RESULT_WINDOW_SETTING = Setting.intSetting("index.max_result_window", 10000, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
        MAX_SCRIPT_FIELDS_SETTING = Setting.intSetting("index.max_script_fields", 32, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
        MAX_INNER_RESULT_WINDOW_SETTING = Setting.intSetting("index.max_inner_result_window", 100, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
        MAX_ANALYZED_OFFSET_SETTING = Setting.intSetting("index.highlight.max_analyzed_offset", -1, -1, Setting.Property.Dynamic, Setting.Property.IndexScope);
        MAX_TERMS_COUNT_SETTING = Setting.intSetting("index.max_terms_count", 65536, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
        MAX_NGRAM_DIFF_SETTING = Setting.intSetting("index.max_ngram_diff", 1, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
        MAX_SHINGLE_DIFF_SETTING = Setting.intSetting("index.max_shingle_diff", 3, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
        MAX_DOCVALUE_FIELDS_SEARCH_SETTING = Setting.intSetting("index.max_docvalue_fields_search", 100, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
        MAX_RESCORE_WINDOW_SETTING = Setting.intSetting("index.max_rescore_window", MAX_RESULT_WINDOW_SETTING, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
        MAX_ADJACENCY_MATRIX_FILTERS_SETTING = Setting.intSetting("index.max_adjacency_matrix_filters", 100, 2, Setting.Property.Dynamic, Setting.Property.IndexScope);
        DEFAULT_REFRESH_INTERVAL = new TimeValue(1L, TimeUnit.SECONDS);
        INDEX_REFRESH_INTERVAL_SETTING = Setting.timeSetting("index.refresh_interval", DEFAULT_REFRESH_INTERVAL, new TimeValue(-1L, TimeUnit.MILLISECONDS), Setting.Property.Dynamic, Setting.Property.IndexScope);
        INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING = Setting.byteSizeSetting("index.translog.flush_threshold_size", new ByteSizeValue(512L, ByteSizeUnit.MB), new ByteSizeValue(Translog.DEFAULT_HEADER_SIZE_IN_BYTES + 1, ByteSizeUnit.BYTES), new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.BYTES), Setting.Property.Dynamic, Setting.Property.IndexScope);
        INDEX_TRANSLOG_RETENTION_AGE_SETTING = Setting.timeSetting("index.translog.retention.age", TimeValue.timeValueHours((long)12L), TimeValue.timeValueMillis((long)-1L), Setting.Property.Dynamic, Setting.Property.IndexScope);
        INDEX_TRANSLOG_RETENTION_SIZE_SETTING = Setting.byteSizeSetting("index.translog.retention.size", new ByteSizeValue(512L, ByteSizeUnit.MB), Setting.Property.Dynamic, Setting.Property.IndexScope);
        INDEX_TRANSLOG_GENERATION_THRESHOLD_SIZE_SETTING = Setting.byteSizeSetting("index.translog.generation_threshold_size", new ByteSizeValue(64L, ByteSizeUnit.MB), new ByteSizeValue(Translog.DEFAULT_HEADER_SIZE_IN_BYTES + 1, ByteSizeUnit.BYTES), new ByteSizeValue(Long.MAX_VALUE, ByteSizeUnit.BYTES), Setting.Property.Dynamic, Setting.Property.IndexScope);
        DEFAULT_GC_DELETES = TimeValue.timeValueSeconds((long)60L);
        INDEX_GC_DELETES_SETTING = Setting.timeSetting("index.gc_deletes", DEFAULT_GC_DELETES, new TimeValue(-1L, TimeUnit.MILLISECONDS), Setting.Property.Dynamic, Setting.Property.IndexScope);
        MAX_REFRESH_LISTENERS_PER_SHARD = Setting.intSetting("index.max_refresh_listeners", 1000, 0, Setting.Property.Dynamic, Setting.Property.IndexScope);
        MAX_SLICES_PER_SCROLL = Setting.intSetting("index.max_slices_per_scroll", 1024, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
        MAX_REGEX_LENGTH_SETTING = Setting.intSetting("index.max_regex_length", 1000, 1, Setting.Property.Dynamic, Setting.Property.IndexScope);
        defValue = settings -> {
            boolean singleType = true;
            if (settings.getAsVersion("index.version.created", null) != null) {
                singleType = Version.indexCreated(settings).onOrAfter(Version.V_6_0_0_alpha1);
            }
            return Boolean.valueOf(singleType).toString();
        };
        INDEX_MAPPING_SINGLE_TYPE_SETTING = Setting.boolSetting(INDEX_MAPPING_SINGLE_TYPE_SETTING_KEY, defValue, Setting.Property.IndexScope, Setting.Property.Final);
    }
}

