/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkItemResultHolder;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.bulk.MappingUpdatePerformer;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class TransportShardBulkAction
extends TransportWriteAction<BulkShardRequest, BulkShardRequest, BulkShardResponse> {
    public static final String ACTION_NAME = "indices:data/write/bulk[s]";
    private static final Logger logger = ESLoggerFactory.getLogger(TransportShardBulkAction.class);
    private final UpdateHelper updateHelper;
    private final MappingUpdatedAction mappingUpdatedAction;

    @Inject
    public TransportShardBulkAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, MappingUpdatedAction mappingUpdatedAction, UpdateHelper updateHelper, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, BulkShardRequest::new, BulkShardRequest::new, "write");
        this.updateHelper = updateHelper;
        this.mappingUpdatedAction = mappingUpdatedAction;
    }

    @Override
    protected TransportRequestOptions transportOptions() {
        return BulkAction.INSTANCE.transportOptions(this.settings);
    }

    @Override
    protected BulkShardResponse newResponseInstance() {
        return new BulkShardResponse();
    }

    @Override
    protected boolean resolveIndex() {
        return false;
    }

    @Override
    public TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse> shardOperationOnPrimary(BulkShardRequest request, IndexShard primary) throws Exception {
        return TransportShardBulkAction.performOnPrimary(request, primary, this.updateHelper, this.threadPool::absoluteTimeInMillis, new ConcreteMappingUpdatePerformer());
    }

    public static TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse> performOnPrimary(BulkShardRequest request, IndexShard primary, UpdateHelper updateHelper, LongSupplier nowInMillisSupplier, MappingUpdatePerformer mappingUpdater) throws Exception {
        IndexMetaData metaData = primary.indexSettings().getIndexMetaData();
        Translog.Location location = null;
        for (int requestIndex = 0; requestIndex < request.items().length; ++requestIndex) {
            if (TransportShardBulkAction.isAborted(request.items()[requestIndex].getPrimaryResponse())) continue;
            location = TransportShardBulkAction.executeBulkItemRequest(metaData, primary, request, location, requestIndex, updateHelper, nowInMillisSupplier, mappingUpdater);
        }
        BulkItemResponse[] responses = new BulkItemResponse[request.items().length];
        BulkItemRequest[] items = request.items();
        for (int i = 0; i < items.length; ++i) {
            responses[i] = items[i].getPrimaryResponse();
        }
        BulkShardResponse response = new BulkShardResponse(request.shardId(), responses);
        return new TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse>(request, response, location, null, primary, logger);
    }

    private static BulkItemResultHolder executeIndexRequest(IndexRequest indexRequest, BulkItemRequest bulkItemRequest, IndexShard primary, MappingUpdatePerformer mappingUpdater) throws Exception {
        Engine.IndexResult indexResult = TransportShardBulkAction.executeIndexRequestOnPrimary(indexRequest, primary, mappingUpdater);
        switch (indexResult.getResultType()) {
            case SUCCESS: {
                IndexResponse response = new IndexResponse(primary.shardId(), indexRequest.type(), indexRequest.id(), indexResult.getSeqNo(), indexResult.getTerm(), indexResult.getVersion(), indexResult.isCreated());
                return new BulkItemResultHolder(response, indexResult, bulkItemRequest);
            }
            case FAILURE: {
                return new BulkItemResultHolder(null, indexResult, bulkItemRequest);
            }
        }
        throw new AssertionError((Object)("unknown result type for " + indexRequest + ": " + (Object)((Object)indexResult.getResultType())));
    }

    private static BulkItemResultHolder executeDeleteRequest(DeleteRequest deleteRequest, BulkItemRequest bulkItemRequest, IndexShard primary, MappingUpdatePerformer mappingUpdater) throws Exception {
        Engine.DeleteResult deleteResult = TransportShardBulkAction.executeDeleteRequestOnPrimary(deleteRequest, primary, mappingUpdater);
        switch (deleteResult.getResultType()) {
            case SUCCESS: {
                DeleteResponse response = new DeleteResponse(primary.shardId(), deleteRequest.type(), deleteRequest.id(), deleteResult.getSeqNo(), deleteResult.getTerm(), deleteResult.getVersion(), deleteResult.isFound());
                return new BulkItemResultHolder(response, deleteResult, bulkItemRequest);
            }
            case FAILURE: {
                return new BulkItemResultHolder(null, deleteResult, bulkItemRequest);
            }
            case MAPPING_UPDATE_REQUIRED: {
                throw new AssertionError((Object)("delete operation leaked a mapping update " + deleteRequest));
            }
        }
        throw new AssertionError((Object)("unknown result type for " + deleteRequest + ": " + (Object)((Object)deleteResult.getResultType())));
    }

    static Translog.Location calculateTranslogLocation(Translog.Location originalLocation, BulkItemResultHolder bulkItemResult) {
        Engine.Result operationResult = bulkItemResult.operationResult;
        if (operationResult != null && operationResult.getResultType() == Engine.Result.Type.SUCCESS) {
            return TransportShardBulkAction.locationToSync(originalLocation, operationResult.getTranslogLocation());
        }
        return originalLocation;
    }

    static BulkItemResponse createPrimaryResponse(BulkItemResultHolder bulkItemResult, DocWriteRequest.OpType opType, BulkShardRequest request) {
        Engine.Result operationResult = bulkItemResult.operationResult;
        DocWriteResponse response = bulkItemResult.response;
        BulkItemRequest replicaRequest = bulkItemResult.replicaRequest;
        if (operationResult == null) {
            assert (response.getResult() == DocWriteResponse.Result.NOOP) : "only noop updates can have a null operation";
            return new BulkItemResponse(replicaRequest.id(), opType, response);
        }
        if (operationResult.getResultType() == Engine.Result.Type.SUCCESS) {
            BulkItemResponse primaryResponse = new BulkItemResponse(replicaRequest.id(), opType, response);
            ((ReplicationResponse)primaryResponse.getResponse()).setShardInfo(new ReplicationResponse.ShardInfo());
            return primaryResponse;
        }
        if (operationResult.getResultType() == Engine.Result.Type.FAILURE) {
            DocWriteRequest docWriteRequest = replicaRequest.request();
            Exception failure = operationResult.getFailure();
            if (TransportShardBulkAction.isConflictException(failure)) {
                logger.trace(() -> new ParameterizedMessage("{} failed to execute bulk item ({}) {}", new Object[]{request.shardId(), docWriteRequest.opType().getLowercase(), request}), (Throwable)failure);
            } else {
                logger.debug(() -> new ParameterizedMessage("{} failed to execute bulk item ({}) {}", new Object[]{request.shardId(), docWriteRequest.opType().getLowercase(), request}), (Throwable)failure);
            }
            if (replicaRequest.getPrimaryResponse() == null || !TransportShardBulkAction.isConflictException(failure)) {
                return new BulkItemResponse(replicaRequest.id(), docWriteRequest.opType(), new BulkItemResponse.Failure(request.index(), docWriteRequest.type(), docWriteRequest.id(), failure, operationResult.getSeqNo()));
            }
            assert (replicaRequest.getPrimaryResponse() != null) : "replica request must have a primary response";
            return null;
        }
        throw new AssertionError((Object)("unknown result type for " + request + ": " + (Object)((Object)operationResult.getResultType())));
    }

    static Translog.Location executeBulkItemRequest(IndexMetaData metaData, IndexShard primary, BulkShardRequest request, Translog.Location location, int requestIndex, UpdateHelper updateHelper, LongSupplier nowInMillisSupplier, MappingUpdatePerformer mappingUpdater) throws Exception {
        BulkItemRequest replicaRequest;
        BulkItemResultHolder responseHolder;
        DocWriteRequest itemRequest = request.items()[requestIndex].request();
        DocWriteRequest.OpType opType = itemRequest.opType();
        switch (itemRequest.opType()) {
            case CREATE: 
            case INDEX: {
                responseHolder = TransportShardBulkAction.executeIndexRequest((IndexRequest)itemRequest, request.items()[requestIndex], primary, mappingUpdater);
                break;
            }
            case UPDATE: {
                responseHolder = TransportShardBulkAction.executeUpdateRequest((UpdateRequest)itemRequest, primary, metaData, request, requestIndex, updateHelper, nowInMillisSupplier, mappingUpdater);
                break;
            }
            case DELETE: {
                responseHolder = TransportShardBulkAction.executeDeleteRequest((DeleteRequest)itemRequest, request.items()[requestIndex], primary, mappingUpdater);
                break;
            }
            default: {
                throw new IllegalStateException("unexpected opType [" + (Object)((Object)itemRequest.opType()) + "] found");
            }
        }
        request.items()[requestIndex] = replicaRequest = responseHolder.replicaRequest;
        BulkItemResponse primaryResponse = TransportShardBulkAction.createPrimaryResponse(responseHolder, opType, request);
        if (primaryResponse != null) {
            replicaRequest.setPrimaryResponse(primaryResponse);
        }
        return TransportShardBulkAction.calculateTranslogLocation(location, responseHolder);
    }

    private static boolean isAborted(BulkItemResponse response) {
        return response != null && response.isFailed() && response.getFailure().isAborted();
    }

    private static boolean isConflictException(Exception e) {
        return ExceptionsHelper.unwrapCause(e) instanceof VersionConflictEngineException;
    }

    static BulkItemResultHolder processUpdateResponse(UpdateRequest updateRequest, String concreteIndex, Engine.Result result, UpdateHelper.Result translate, IndexShard primary, int bulkReqId) {
        BulkItemRequest replicaRequest;
        UpdateResponse updateResponse;
        assert (result.getSeqNo() != -2L) : "failed result should not have a sequence number";
        Engine.Operation.TYPE opType = result.getOperationType();
        if (opType == Engine.Operation.TYPE.INDEX) {
            assert (result instanceof Engine.IndexResult) : result.getClass();
            IndexRequest updateIndexRequest = (IndexRequest)translate.action();
            IndexResponse indexResponse = new IndexResponse(primary.shardId(), updateIndexRequest.type(), updateIndexRequest.id(), result.getSeqNo(), result.getTerm(), result.getVersion(), ((Engine.IndexResult)result).isCreated());
            updateResponse = new UpdateResponse(indexResponse.getShardInfo(), indexResponse.getShardId(), indexResponse.getType(), indexResponse.getId(), indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), indexResponse.getVersion(), indexResponse.getResult());
            if (updateRequest.fetchSource() != null && updateRequest.fetchSource().fetchSource() || updateRequest.fields() != null && updateRequest.fields().length > 0) {
                BytesReference indexSourceAsBytes = updateIndexRequest.source();
                Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(indexSourceAsBytes, true, updateIndexRequest.getContentType());
                updateResponse.setGetResult(UpdateHelper.extractGetResult(updateRequest, concreteIndex, indexResponse.getVersion(), (Map)sourceAndContent.v2(), (XContentType)sourceAndContent.v1(), indexSourceAsBytes));
            }
            replicaRequest = new BulkItemRequest(bulkReqId, updateIndexRequest);
        } else if (opType == Engine.Operation.TYPE.DELETE) {
            assert (result instanceof Engine.DeleteResult) : result.getClass();
            DeleteRequest updateDeleteRequest = (DeleteRequest)translate.action();
            DeleteResponse deleteResponse = new DeleteResponse(primary.shardId(), updateDeleteRequest.type(), updateDeleteRequest.id(), result.getSeqNo(), result.getTerm(), result.getVersion(), ((Engine.DeleteResult)result).isFound());
            updateResponse = new UpdateResponse(deleteResponse.getShardInfo(), deleteResponse.getShardId(), deleteResponse.getType(), deleteResponse.getId(), deleteResponse.getSeqNo(), deleteResponse.getPrimaryTerm(), deleteResponse.getVersion(), deleteResponse.getResult());
            GetResult getResult = UpdateHelper.extractGetResult(updateRequest, concreteIndex, deleteResponse.getVersion(), translate.updatedSourceAsMap(), translate.updateSourceContentType(), null);
            updateResponse.setGetResult(getResult);
            replicaRequest = new BulkItemRequest(bulkReqId, updateDeleteRequest);
        } else {
            throw new IllegalArgumentException("unknown operation type: " + (Object)((Object)opType));
        }
        return new BulkItemResultHolder(updateResponse, result, replicaRequest);
    }

    static BulkItemResultHolder executeUpdateRequestOnce(UpdateRequest updateRequest, IndexShard primary, IndexMetaData metaData, String concreteIndex, UpdateHelper updateHelper, LongSupplier nowInMillis, BulkItemRequest primaryItemRequest, int bulkReqId, MappingUpdatePerformer mappingUpdater) throws Exception {
        Engine.Result result;
        UpdateHelper.Result translate;
        try {
            translate = updateHelper.prepare(updateRequest, primary, nowInMillis);
        }
        catch (Exception failure) {
            Engine.IndexResult result2 = primary.getFailedIndexResult(failure, updateRequest.version());
            return new BulkItemResultHolder(null, result2, primaryItemRequest);
        }
        switch (translate.getResponseResult()) {
            case CREATED: 
            case UPDATED: {
                IndexRequest indexRequest = (IndexRequest)translate.action();
                MappingMetaData mappingMd = metaData.mappingOrDefault(indexRequest.type());
                indexRequest.process(metaData.getCreationVersion(), mappingMd, concreteIndex);
                result = TransportShardBulkAction.executeIndexRequestOnPrimary(indexRequest, primary, mappingUpdater);
                break;
            }
            case DELETED: {
                DeleteRequest deleteRequest = (DeleteRequest)translate.action();
                result = TransportShardBulkAction.executeDeleteRequestOnPrimary(deleteRequest, primary, mappingUpdater);
                break;
            }
            case NOOP: {
                primary.noopUpdate(updateRequest.type());
                result = null;
                break;
            }
            default: {
                throw new IllegalStateException("Illegal update operation " + translate.getResponseResult());
            }
        }
        if (result == null) {
            UpdateResponse updateResponse = (UpdateResponse)translate.action();
            return new BulkItemResultHolder(updateResponse, result, primaryItemRequest);
        }
        if (result.getResultType() == Engine.Result.Type.FAILURE) {
            return new BulkItemResultHolder(null, result, primaryItemRequest);
        }
        if (result.getResultType() == Engine.Result.Type.SUCCESS) {
            return TransportShardBulkAction.processUpdateResponse(updateRequest, concreteIndex, result, translate, primary, bulkReqId);
        }
        throw new AssertionError((Object)("unknown result type for " + updateRequest + ": " + (Object)((Object)result.getResultType())));
    }

    private static BulkItemResultHolder executeUpdateRequest(UpdateRequest updateRequest, IndexShard primary, IndexMetaData metaData, BulkShardRequest request, int requestIndex, UpdateHelper updateHelper, LongSupplier nowInMillis, MappingUpdatePerformer mappingUpdater) throws Exception {
        BulkItemRequest primaryItemRequest = request.items()[requestIndex];
        assert (primaryItemRequest.request() == updateRequest) : "expected bulk item request to contain the original update request, got: " + primaryItemRequest.request() + " and " + updateRequest;
        BulkItemResultHolder holder = null;
        int maxAttempts = Math.max(1, updateRequest.retryOnConflict());
        for (int attemptCount = 0; attemptCount < maxAttempts; ++attemptCount) {
            holder = TransportShardBulkAction.executeUpdateRequestOnce(updateRequest, primary, metaData, request.index(), updateHelper, nowInMillis, primaryItemRequest, request.items()[requestIndex].id(), mappingUpdater);
            if (holder.isVersionConflict()) continue;
            return holder;
        }
        return holder;
    }

    static ReplicaItemExecutionMode replicaItemExecutionMode(BulkItemRequest request, int index) {
        BulkItemResponse primaryResponse = request.getPrimaryResponse();
        assert (primaryResponse != null) : "expected primary response to be set for item [" + index + "] request [" + request.request() + "]";
        if (primaryResponse.isFailed()) {
            return primaryResponse.getFailure().getSeqNo() != -2L ? ReplicaItemExecutionMode.FAILURE : ReplicaItemExecutionMode.NOOP;
        }
        return ((DocWriteResponse)primaryResponse.getResponse()).getResult() != DocWriteResponse.Result.NOOP ? ReplicaItemExecutionMode.NORMAL : ReplicaItemExecutionMode.NOOP;
    }

    @Override
    public TransportWriteAction.WriteReplicaResult<BulkShardRequest> shardOperationOnReplica(BulkShardRequest request, IndexShard replica) throws Exception {
        Translog.Location location = TransportShardBulkAction.performOnReplica(request, replica);
        return new TransportWriteAction.WriteReplicaResult<BulkShardRequest>(request, location, null, replica, logger);
    }

    public static Translog.Location performOnReplica(BulkShardRequest request, IndexShard replica) throws Exception {
        Translog.Location location = null;
        block5: for (int i = 0; i < request.items().length; ++i) {
            BulkItemRequest item = request.items()[i];
            DocWriteRequest docWriteRequest = item.request();
            switch (TransportShardBulkAction.replicaItemExecutionMode(item, i)) {
                case NORMAL: {
                    Object primaryResponse = item.getPrimaryResponse().getResponse();
                    Engine.Result operationResult = TransportShardBulkAction.performOpOnReplica(primaryResponse, docWriteRequest, replica);
                    assert (operationResult != null) : "operation result must never be null when primary response has no failure";
                    location = TransportShardBulkAction.syncOperationResultOrThrow(operationResult, location);
                    continue block5;
                }
                case NOOP: {
                    continue block5;
                }
                case FAILURE: {
                    BulkItemResponse.Failure failure = item.getPrimaryResponse().getFailure();
                    assert (failure.getSeqNo() != -2L) : "seq no must be assigned";
                    Engine.Result operationResult = replica.markSeqNoAsNoop(failure.getSeqNo(), failure.getMessage());
                    assert (operationResult != null) : "operation result must never be null when primary response has no failure";
                    location = TransportShardBulkAction.syncOperationResultOrThrow(operationResult, location);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("illegal replica item execution mode for: " + docWriteRequest);
                }
            }
        }
        return location;
    }

    private static Engine.Result performOpOnReplica(DocWriteResponse primaryResponse, DocWriteRequest docWriteRequest, IndexShard replica) throws Exception {
        Engine.Result result;
        switch (docWriteRequest.opType()) {
            case CREATE: 
            case INDEX: {
                IndexRequest indexRequest = (IndexRequest)docWriteRequest;
                ShardId shardId = replica.shardId();
                SourceToParse sourceToParse = SourceToParse.source(shardId.getIndexName(), indexRequest.type(), indexRequest.id(), indexRequest.source(), indexRequest.getContentType()).routing(indexRequest.routing()).parent(indexRequest.parent());
                result = replica.applyIndexOperationOnReplica(primaryResponse.getSeqNo(), primaryResponse.getVersion(), indexRequest.versionType().versionTypeForReplicationAndRecovery(), indexRequest.getAutoGeneratedTimestamp(), indexRequest.isRetry(), sourceToParse);
                break;
            }
            case DELETE: {
                DeleteRequest deleteRequest = (DeleteRequest)docWriteRequest;
                result = replica.applyDeleteOperationOnReplica(primaryResponse.getSeqNo(), primaryResponse.getVersion(), deleteRequest.type(), deleteRequest.id(), deleteRequest.versionType().versionTypeForReplicationAndRecovery());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected request operation type on replica: " + docWriteRequest.opType().getLowercase());
            }
        }
        if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
            throw new TransportReplicationAction.RetryOnReplicaException(replica.shardId(), "Mappings are not available on the replica yet, triggered update: " + result.getRequiredMappingUpdate());
        }
        return result;
    }

    static Engine.IndexResult executeIndexRequestOnPrimary(IndexRequest request, IndexShard primary, MappingUpdatePerformer mappingUpdater) throws Exception {
        SourceToParse sourceToParse = SourceToParse.source(request.index(), request.type(), request.id(), request.source(), request.getContentType()).routing(request.routing()).parent(request.parent());
        return TransportShardBulkAction.executeOnPrimaryWhileHandlingMappingUpdates(primary.shardId(), request.type(), () -> primary.applyIndexOperationOnPrimary(request.version(), request.versionType(), sourceToParse, request.getAutoGeneratedTimestamp(), request.isRetry()), e -> primary.getFailedIndexResult((Exception)e, request.version()), mappingUpdater);
    }

    private static Engine.DeleteResult executeDeleteRequestOnPrimary(DeleteRequest request, IndexShard primary, MappingUpdatePerformer mappingUpdater) throws Exception {
        return TransportShardBulkAction.executeOnPrimaryWhileHandlingMappingUpdates(primary.shardId(), request.type(), () -> primary.applyDeleteOperationOnPrimary(request.version(), request.type(), request.id(), request.versionType()), e -> primary.getFailedDeleteResult((Exception)e, request.version()), mappingUpdater);
    }

    private static <T extends Engine.Result> T executeOnPrimaryWhileHandlingMappingUpdates(ShardId shardId, String type, CheckedSupplier<T, IOException> toExecute, Function<Exception, T> onError, MappingUpdatePerformer mappingUpdater) throws IOException {
        Engine.Result result = (Engine.Result)toExecute.get();
        if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
            try {
                mappingUpdater.updateMappings(result.getRequiredMappingUpdate(), shardId, type);
            }
            catch (Exception e) {
                return (T)((Engine.Result)onError.apply(e));
            }
            result = (Engine.Result)toExecute.get();
            if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                throw new ReplicationOperation.RetryOnPrimaryException(shardId, "Dynamic mappings are not available on the node that holds the primary yet");
            }
        }
        assert (!(result.getFailure() instanceof ReplicationOperation.RetryOnPrimaryException)) : "IndexShard shouldn't use RetryOnPrimaryException. got " + result.getFailure();
        return (T)result;
    }

    class ConcreteMappingUpdatePerformer
    implements MappingUpdatePerformer {
        ConcreteMappingUpdatePerformer() {
        }

        @Override
        public void updateMappings(Mapping update, ShardId shardId, String type) {
            assert (update != null);
            assert (shardId != null);
            TransportShardBulkAction.this.mappingUpdatedAction.updateMappingOnMaster(shardId.getIndex(), type, update);
        }
    }

    public static enum ReplicaItemExecutionMode {
        NORMAL,
        NOOP,
        FAILURE;

    }
}

