/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.painless.Constant;
import org.elasticsearch.painless.node.SFunction;

public class Globals {
    private final Map<String, SFunction> syntheticMethods = new HashMap<String, SFunction>();
    private final Map<String, Constant> constantInitializers = new HashMap<String, Constant>();
    private final BitSet statements;

    public Globals(BitSet statements) {
        this.statements = statements;
    }

    public void addSyntheticMethod(SFunction function) {
        if (!function.synthetic) {
            throw new IllegalStateException("method: " + function.name + " is not synthetic");
        }
        if (this.syntheticMethods.put(function.name, function) != null) {
            throw new IllegalStateException("synthetic method: " + function.name + " already exists");
        }
    }

    public void addConstantInitializer(Constant constant) {
        if (this.constantInitializers.put(constant.name, constant) != null) {
            throw new IllegalStateException("constant initializer: " + constant.name + " already exists");
        }
    }

    public Map<String, SFunction> getSyntheticMethods() {
        return this.syntheticMethods;
    }

    public Map<String, Constant> getConstantInitializers() {
        return this.constantInitializers;
    }

    public BitSet getStatements() {
        return this.statements;
    }
}

