/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.lucene.uid.VersionsAndSeqNoResolver;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fieldvisitor.CustomFieldsVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.fetch.subphase.ParentFieldSubFetchPhase;

public final class ShardGetService
extends AbstractIndexShardComponent {
    private final MapperService mapperService;
    private final MeanMetric existsMetric = new MeanMetric();
    private final MeanMetric missingMetric = new MeanMetric();
    private final CounterMetric currentMetric = new CounterMetric();
    private final IndexShard indexShard;

    public ShardGetService(IndexSettings indexSettings, IndexShard indexShard, MapperService mapperService) {
        super(indexShard.shardId(), indexSettings);
        this.mapperService = mapperService;
        this.indexShard = indexShard;
    }

    public GetStats stats() {
        return new GetStats(this.existsMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.existsMetric.sum()), this.missingMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.missingMetric.sum()), this.currentMetric.count());
    }

    public GetResult get(String type, String id, String[] gFields, boolean realtime, long version, VersionType versionType, FetchSourceContext fetchSourceContext) {
        return this.get(type, id, gFields, realtime, version, versionType, fetchSourceContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GetResult get(String type, String id, String[] gFields, boolean realtime, long version, VersionType versionType, FetchSourceContext fetchSourceContext, boolean readFromTranslog) {
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            GetResult getResult = this.innerGet(type, id, gFields, realtime, version, versionType, fetchSourceContext, readFromTranslog);
            if (getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    public GetResult getForUpdate(String type, String id, long version, VersionType versionType) {
        return this.get(type, id, new String[]{"_routing", "_parent"}, true, version, versionType, FetchSourceContext.FETCH_SOURCE, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult get(Engine.GetResult engineGetResult, String id, String type, String[] fields, FetchSourceContext fetchSourceContext) {
        if (!engineGetResult.exists()) {
            return new GetResult(this.shardId.getIndexName(), type, id, -1L, false, null, null);
        }
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            fetchSourceContext = this.normalizeFetchSourceContent(fetchSourceContext, fields);
            GetResult getResult = this.innerGetLoadFromStoredFields(type, id, fields, fetchSourceContext, engineGetResult, this.mapperService);
            if (getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    private FetchSourceContext normalizeFetchSourceContent(@Nullable FetchSourceContext context, @Nullable String[] gFields) {
        if (context != null) {
            return context;
        }
        if (gFields == null) {
            return FetchSourceContext.FETCH_SOURCE;
        }
        for (String field : gFields) {
            if (!"_source".equals(field)) continue;
            return FetchSourceContext.FETCH_SOURCE;
        }
        return FetchSourceContext.DO_NOT_FETCH_SOURCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GetResult innerGet(String type, String id, String[] gFields, boolean realtime, long version, VersionType versionType, FetchSourceContext fetchSourceContext, boolean readFromTranslog) {
        fetchSourceContext = this.normalizeFetchSourceContent(fetchSourceContext, gFields);
        Collection<String> types = type == null || type.equals("_all") ? this.mapperService.types() : Collections.singleton(type);
        Engine.GetResult get = null;
        for (String typeX : types) {
            Term uidTerm = this.mapperService.createUidTerm(typeX, id);
            if (uidTerm == null) continue;
            get = this.indexShard.get(new Engine.Get(realtime, readFromTranslog, typeX, id, uidTerm).version(version).versionType(versionType));
            if (get.exists()) {
                type = typeX;
                break;
            }
            get.release();
        }
        if (get == null || !get.exists()) {
            return new GetResult(this.shardId.getIndexName(), type, id, -1L, false, null, null);
        }
        try {
            GetResult getResult = this.innerGetLoadFromStoredFields(type, id, gFields, fetchSourceContext, get, this.mapperService);
            return getResult;
        }
        finally {
            get.release();
        }
    }

    private GetResult innerGetLoadFromStoredFields(String type, String id, String[] gFields, FetchSourceContext fetchSourceContext, Engine.GetResult get, MapperService mapperService) {
        DocumentMapper docMapper;
        HashMap<String, DocumentField> fields = null;
        BytesReference source = null;
        VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion = get.docIdAndVersion();
        FieldsVisitor fieldVisitor = ShardGetService.buildFieldsVisitors(gFields, fetchSourceContext);
        if (fieldVisitor != null) {
            try {
                docIdAndVersion.reader.document(docIdAndVersion.docId, (StoredFieldVisitor)fieldVisitor);
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to get type [" + type + "] and id [" + id + "]", (Throwable)e, new Object[0]);
            }
            source = fieldVisitor.source();
            if (!fieldVisitor.fields().isEmpty()) {
                fieldVisitor.postProcess(mapperService);
                fields = new HashMap(fieldVisitor.fields().size());
                for (Map.Entry<String, List<Object>> entry : fieldVisitor.fields().entrySet()) {
                    fields.put(entry.getKey(), new DocumentField(entry.getKey(), entry.getValue()));
                }
            }
        }
        if ((docMapper = mapperService.documentMapper(type)).parentFieldMapper().active()) {
            String string = ParentFieldSubFetchPhase.getParentId(docMapper.parentFieldMapper(), docIdAndVersion.reader, docIdAndVersion.docId);
            if (fields == null) {
                fields = new HashMap<String, DocumentField>(1);
            }
            fields.put("_parent", new DocumentField("_parent", Collections.singletonList(string)));
        }
        if (gFields != null && gFields.length > 0) {
            for (String field : gFields) {
                Mapper fieldMapper = docMapper.mappers().getMapper(field);
                if (fieldMapper != null || docMapper.objectMappers().get(field) == null) continue;
                throw new IllegalArgumentException("field [" + field + "] isn't a leaf field");
            }
        }
        if (!fetchSourceContext.fetchSource()) {
            source = null;
        } else if (fetchSourceContext.includes().length > 0 || fetchSourceContext.excludes().length > 0) {
            XContentType sourceContentType = null;
            Tuple<XContentType, Map<String, Object>> typeMapTuple = XContentHelper.convertToMap(source, true);
            sourceContentType = (XContentType)typeMapTuple.v1();
            Map map = (Map)typeMapTuple.v2();
            Map<String, Object> map2 = XContentMapValues.filter(map, fetchSourceContext.includes(), fetchSourceContext.excludes());
            try {
                source = BytesReference.bytes(XContentFactory.contentBuilder((XContentType)sourceContentType).map(map2));
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to get type [" + type + "] and id [" + id + "] with includes/excludes set", (Throwable)e, new Object[0]);
            }
        }
        return new GetResult(this.shardId.getIndexName(), type, id, get.version(), get.exists(), source, fields);
    }

    private static FieldsVisitor buildFieldsVisitors(String[] fields, FetchSourceContext fetchSourceContext) {
        if (fields == null || fields.length == 0) {
            return fetchSourceContext.fetchSource() ? new FieldsVisitor(true) : null;
        }
        return new CustomFieldsVisitor(Sets.newHashSet(fields), fetchSourceContext.fetchSource());
    }
}

