/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.net.SocketAddress;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4HttpRequest
extends RestRequest {
    private final FullHttpRequest request;
    private final Channel channel;
    private final BytesReference content;

    Netty4HttpRequest(NamedXContentRegistry xContentRegistry, FullHttpRequest request, Channel channel) {
        super(xContentRegistry, request.uri(), (Map)new HttpHeadersMap(request.headers()));
        this.request = request;
        this.channel = channel;
        this.content = request.content().isReadable() ? Netty4Utils.toBytesReference(request.content()) : BytesArray.EMPTY;
    }

    Netty4HttpRequest(NamedXContentRegistry xContentRegistry, Map<String, String> params, String uri, FullHttpRequest request, Channel channel) {
        super(xContentRegistry, params, uri, (Map)new HttpHeadersMap(request.headers()));
        this.request = request;
        this.channel = channel;
        this.content = request.content().isReadable() ? Netty4Utils.toBytesReference(request.content()) : BytesArray.EMPTY;
    }

    public FullHttpRequest request() {
        return this.request;
    }

    public RestRequest.Method method() {
        HttpMethod httpMethod = this.request.method();
        if (httpMethod == HttpMethod.GET) {
            return RestRequest.Method.GET;
        }
        if (httpMethod == HttpMethod.POST) {
            return RestRequest.Method.POST;
        }
        if (httpMethod == HttpMethod.PUT) {
            return RestRequest.Method.PUT;
        }
        if (httpMethod == HttpMethod.DELETE) {
            return RestRequest.Method.DELETE;
        }
        if (httpMethod == HttpMethod.HEAD) {
            return RestRequest.Method.HEAD;
        }
        if (httpMethod == HttpMethod.OPTIONS) {
            return RestRequest.Method.OPTIONS;
        }
        if (httpMethod == HttpMethod.PATCH) {
            return RestRequest.Method.PATCH;
        }
        if (httpMethod == HttpMethod.TRACE) {
            return RestRequest.Method.TRACE;
        }
        if (httpMethod == HttpMethod.CONNECT) {
            return RestRequest.Method.CONNECT;
        }
        throw new IllegalArgumentException("Unexpected http method: " + httpMethod);
    }

    public String uri() {
        return this.request.uri();
    }

    public boolean hasContent() {
        return this.content.length() > 0;
    }

    public BytesReference content() {
        return this.content;
    }

    public SocketAddress getRemoteAddress() {
        return this.channel.remoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.channel.localAddress();
    }

    public Channel getChannel() {
        return this.channel;
    }

    private static class HttpHeadersMap
    implements Map<String, List<String>> {
        private final HttpHeaders httpHeaders;

        private HttpHeadersMap(HttpHeaders httpHeaders) {
            this.httpHeaders = httpHeaders;
        }

        @Override
        public int size() {
            return this.httpHeaders.size();
        }

        @Override
        public boolean isEmpty() {
            return this.httpHeaders.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return key instanceof String && this.httpHeaders.contains((String)key);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean containsValue(Object value) {
            if (!(value instanceof List)) return false;
            if (!this.httpHeaders.names().stream().map(arg_0 -> ((HttpHeaders)this.httpHeaders).getAll(arg_0)).anyMatch(value::equals)) return false;
            return true;
        }

        @Override
        public List<String> get(Object key) {
            return key instanceof String ? this.httpHeaders.getAll((String)key) : null;
        }

        @Override
        public List<String> put(String key, List<String> value) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public List<String> remove(Object key) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public void putAll(Map<? extends String, ? extends List<String>> m) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public Set<String> keySet() {
            return this.httpHeaders.names();
        }

        @Override
        public Collection<List<String>> values() {
            return this.httpHeaders.names().stream().map(k -> Collections.unmodifiableList(this.httpHeaders.getAll(k))).collect(Collectors.toList());
        }

        @Override
        public Set<Map.Entry<String, List<String>>> entrySet() {
            return this.httpHeaders.names().stream().map(k -> new AbstractMap.SimpleImmutableEntry<String, List>((String)k, this.httpHeaders.getAll(k))).collect(Collectors.toSet());
        }
    }
}

