/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketselector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class BucketSelectorPipelineAggregator
extends PipelineAggregator {
    private BucketHelpers.GapPolicy gapPolicy;
    private Script script;
    private Map<String, String> bucketsPathsMap;

    public BucketSelectorPipelineAggregator(String name, Map<String, String> bucketsPathsMap, Script script, BucketHelpers.GapPolicy gapPolicy, Map<String, Object> metadata) {
        super(name, bucketsPathsMap.values().toArray(new String[bucketsPathsMap.size()]), metadata);
        this.bucketsPathsMap = bucketsPathsMap;
        this.script = script;
        this.gapPolicy = gapPolicy;
    }

    public BucketSelectorPipelineAggregator(StreamInput in) throws IOException {
        super(in);
        this.script = new Script(in);
        this.gapPolicy = BucketHelpers.GapPolicy.readFrom(in);
        this.bucketsPathsMap = (Map)in.readGenericValue();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
        this.gapPolicy.writeTo(out);
        out.writeGenericValue(this.bucketsPathsMap);
    }

    @Override
    public String getWriteableName() {
        return "bucket_selector";
    }

    @Override
    public InternalAggregation reduce(InternalAggregation aggregation, InternalAggregation.ReduceContext reduceContext) {
        InternalMultiBucketAggregation originalAgg = (InternalMultiBucketAggregation)aggregation;
        List<InternalMultiBucketAggregation.InternalBucket> buckets = originalAgg.getBuckets();
        ExecutableScript.Factory factory = reduceContext.scriptService().compile(this.script, ExecutableScript.AGGS_CONTEXT);
        ArrayList<InternalMultiBucketAggregation.InternalBucket> newBuckets = new ArrayList<InternalMultiBucketAggregation.InternalBucket>();
        for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
            double scriptDoubleValue;
            HashMap<String, Object> vars = new HashMap<String, Object>();
            if (this.script.getParams() != null) {
                vars.putAll(this.script.getParams());
            }
            for (Map.Entry<String, String> entry : this.bucketsPathsMap.entrySet()) {
                String varName = entry.getKey();
                String bucketsPath = entry.getValue();
                Double value = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)originalAgg, bucket, bucketsPath, this.gapPolicy);
                vars.put(varName, value);
            }
            ExecutableScript executableScript = factory.newInstance(vars);
            Object scriptReturnValue = executableScript.run();
            boolean keepBucket = "expression".equals(this.script.getLang()) ? (scriptDoubleValue = ((Double)scriptReturnValue).doubleValue()) == 1.0 : (Boolean)scriptReturnValue;
            if (!keepBucket) continue;
            newBuckets.add(bucket);
        }
        return originalAgg.create(newBuckets);
    }
}

