/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class DetailAnalyzeResponse
implements Streamable,
ToXContentFragment {
    private boolean customAnalyzer = false;
    private AnalyzeTokenList analyzer;
    private CharFilteredText[] charfilters;
    private AnalyzeTokenList tokenizer;
    private AnalyzeTokenList[] tokenfilters;

    DetailAnalyzeResponse() {
    }

    public DetailAnalyzeResponse(AnalyzeTokenList analyzer) {
        this(false, analyzer, null, null, null);
    }

    public DetailAnalyzeResponse(CharFilteredText[] charfilters, AnalyzeTokenList tokenizer, AnalyzeTokenList[] tokenfilters) {
        this(true, null, charfilters, tokenizer, tokenfilters);
    }

    public DetailAnalyzeResponse(boolean customAnalyzer, AnalyzeTokenList analyzer, CharFilteredText[] charfilters, AnalyzeTokenList tokenizer, AnalyzeTokenList[] tokenfilters) {
        this.customAnalyzer = customAnalyzer;
        this.analyzer = analyzer;
        this.charfilters = charfilters;
        this.tokenizer = tokenizer;
        this.tokenfilters = tokenfilters;
    }

    public AnalyzeTokenList analyzer() {
        return this.analyzer;
    }

    public DetailAnalyzeResponse analyzer(AnalyzeTokenList analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public CharFilteredText[] charfilters() {
        return this.charfilters;
    }

    public DetailAnalyzeResponse charfilters(CharFilteredText[] charfilters) {
        this.charfilters = charfilters;
        return this;
    }

    public AnalyzeTokenList tokenizer() {
        return this.tokenizer;
    }

    public DetailAnalyzeResponse tokenizer(AnalyzeTokenList tokenizer) {
        this.tokenizer = tokenizer;
        return this;
    }

    public AnalyzeTokenList[] tokenfilters() {
        return this.tokenfilters;
    }

    public DetailAnalyzeResponse tokenfilters(AnalyzeTokenList[] tokenfilters) {
        this.tokenfilters = tokenfilters;
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("custom_analyzer", this.customAnalyzer);
        if (this.analyzer != null) {
            builder.startObject("analyzer");
            this.analyzer.toXContentWithoutObject(builder, params);
            builder.endObject();
        }
        if (this.charfilters != null) {
            builder.startArray("charfilters");
            for (Streamable streamable : this.charfilters) {
                ((CharFilteredText)streamable).toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.tokenizer != null) {
            builder.startObject("tokenizer");
            this.tokenizer.toXContentWithoutObject(builder, params);
            builder.endObject();
        }
        if (this.tokenfilters != null) {
            builder.startArray("tokenfilters");
            for (Streamable streamable : this.tokenfilters) {
                ((AnalyzeTokenList)streamable).toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.customAnalyzer = in.readBoolean();
        if (this.customAnalyzer) {
            int i;
            this.tokenizer = AnalyzeTokenList.readAnalyzeTokenList(in);
            int size = in.readVInt();
            if (size > 0) {
                this.charfilters = new CharFilteredText[size];
                for (i = 0; i < size; ++i) {
                    this.charfilters[i] = CharFilteredText.readCharFilteredText(in);
                }
            }
            if ((size = in.readVInt()) > 0) {
                this.tokenfilters = new AnalyzeTokenList[size];
                for (i = 0; i < size; ++i) {
                    this.tokenfilters[i] = AnalyzeTokenList.readAnalyzeTokenList(in);
                }
            }
        } else {
            this.analyzer = AnalyzeTokenList.readAnalyzeTokenList(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.customAnalyzer);
        if (this.customAnalyzer) {
            this.tokenizer.writeTo(out);
            if (this.charfilters != null) {
                out.writeVInt(this.charfilters.length);
                for (Streamable streamable : this.charfilters) {
                    ((CharFilteredText)streamable).writeTo(out);
                }
            } else {
                out.writeVInt(0);
            }
            if (this.tokenfilters != null) {
                out.writeVInt(this.tokenfilters.length);
                for (Streamable streamable : this.tokenfilters) {
                    ((AnalyzeTokenList)streamable).writeTo(out);
                }
            } else {
                out.writeVInt(0);
            }
        } else {
            this.analyzer.writeTo(out);
        }
    }

    public static class CharFilteredText
    implements Streamable,
    ToXContentObject {
        private String name;
        private String[] texts;

        CharFilteredText() {
        }

        public CharFilteredText(String name, String[] texts) {
            this.name = name;
            this.texts = texts != null ? texts : Strings.EMPTY_ARRAY;
        }

        public String getName() {
            return this.name;
        }

        public String[] getTexts() {
            return this.texts;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.name);
            builder.array("filtered_text", this.texts);
            builder.endObject();
            return builder;
        }

        public static CharFilteredText readCharFilteredText(StreamInput in) throws IOException {
            CharFilteredText text = new CharFilteredText();
            text.readFrom(in);
            return text;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readString();
            this.texts = in.readStringArray();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeStringArray(this.texts);
        }
    }

    public static class AnalyzeTokenList
    implements Streamable,
    ToXContentObject {
        private String name;
        private AnalyzeResponse.AnalyzeToken[] tokens;

        AnalyzeTokenList() {
        }

        public AnalyzeTokenList(String name, AnalyzeResponse.AnalyzeToken[] tokens) {
            this.name = name;
            this.tokens = tokens;
        }

        public String getName() {
            return this.name;
        }

        public AnalyzeResponse.AnalyzeToken[] getTokens() {
            return this.tokens;
        }

        public static AnalyzeTokenList readAnalyzeTokenList(StreamInput in) throws IOException {
            AnalyzeTokenList list = new AnalyzeTokenList();
            list.readFrom(in);
            return list;
        }

        XContentBuilder toXContentWithoutObject(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("name", this.name);
            builder.startArray("tokens");
            for (AnalyzeResponse.AnalyzeToken token : this.tokens) {
                token.toXContent(builder, params);
            }
            builder.endArray();
            return builder;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.toXContentWithoutObject(builder, params);
            builder.endObject();
            return builder;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readString();
            int size = in.readVInt();
            if (size > 0) {
                this.tokens = new AnalyzeResponse.AnalyzeToken[size];
                for (int i = 0; i < size; ++i) {
                    this.tokens[i] = AnalyzeResponse.AnalyzeToken.readAnalyzeToken(in);
                }
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            if (this.tokens != null) {
                out.writeVInt(this.tokens.length);
                for (AnalyzeResponse.AnalyzeToken token : this.tokens) {
                    token.writeTo(out);
                }
            } else {
                out.writeVInt(0);
            }
        }
    }

    static final class Fields {
        static final String NAME = "name";
        static final String FILTERED_TEXT = "filtered_text";
        static final String CUSTOM_ANALYZER = "custom_analyzer";
        static final String ANALYZER = "analyzer";
        static final String CHARFILTERS = "charfilters";
        static final String TOKENIZER = "tokenizer";
        static final String TOKENFILTERS = "tokenfilters";

        Fields() {
        }
    }
}

