/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class NettyTcpChannel
implements TcpChannel {
    private final Channel channel;
    private final CompletableFuture<Void> closeContext = new CompletableFuture();

    NettyTcpChannel(Channel channel) {
        this.channel = channel;
        this.channel.closeFuture().addListener(f -> {
            if (f.isSuccess()) {
                this.closeContext.complete(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    Netty4Utils.maybeDie(cause);
                    this.closeContext.completeExceptionally(cause);
                } else {
                    this.closeContext.completeExceptionally(cause);
                }
            }
        });
    }

    public void close() {
        this.channel.close();
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.whenComplete(ActionListener.toBiConsumer(listener));
    }

    public void setSoLinger(int value) {
        this.channel.config().setOption(ChannelOption.SO_LINGER, (Object)value);
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
        ChannelPromise writePromise = this.channel.newPromise();
        writePromise.addListener(f -> {
            if (f.isSuccess()) {
                listener.onResponse(null);
            } else {
                Throwable cause = f.cause();
                Netty4Utils.maybeDie(cause);
                assert (cause instanceof Exception);
                listener.onFailure((Exception)cause);
            }
        });
        this.channel.writeAndFlush((Object)Netty4Utils.toByteBuf(reference), writePromise);
        if (this.channel.eventLoop().isShutdown()) {
            listener.onFailure((Exception)new TransportException("Cannot send message, event loop is shutting down."));
        }
    }

    public Channel getLowLevelChannel() {
        return this.channel;
    }

    public String toString() {
        return "NettyTcpChannel{localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.channel.remoteAddress() + '}';
    }
}

