/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.AbortingException;
import org.apache.lucene.index.BufferedUpdates;
import org.apache.lucene.index.DefaultIndexingChain;
import org.apache.lucene.index.DocConsumer;
import org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.IntBlockPool;
import org.apache.lucene.util.MutableBits;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

class DocumentsWriterPerThread {
    static final IndexingChain defaultIndexingChain = new IndexingChain(){

        @Override
        DocConsumer getChain(DocumentsWriterPerThread documentsWriterPerThread) throws IOException {
            return new DefaultIndexingChain(documentsWriterPerThread);
        }
    };
    private static final boolean INFO_VERBOSE = false;
    final Codec codec;
    final TrackingDirectoryWrapper directory;
    final Directory directoryOrig;
    final DocState docState;
    final DocConsumer consumer;
    final Counter bytesUsed;
    SegmentWriteState flushState;
    final BufferedUpdates pendingUpdates;
    final SegmentInfo segmentInfo;
    boolean aborted = false;
    private final FieldInfos.Builder fieldInfos;
    private final InfoStream infoStream;
    private int numDocsInRAM;
    final DocumentsWriterDeleteQueue deleteQueue;
    private final DocumentsWriterDeleteQueue.DeleteSlice deleteSlice;
    private final NumberFormat nf = NumberFormat.getInstance(Locale.ROOT);
    final ByteBlockPool.Allocator byteBlockAllocator;
    final IntBlockPool.Allocator intBlockAllocator;
    private final AtomicLong pendingNumDocs;
    private final LiveIndexWriterConfig indexWriterConfig;
    private final boolean enableTestPoints;
    private final IndexWriter indexWriter;
    private final Set<String> filesToDelete = new HashSet<String>();
    static final int BYTE_BLOCK_NOT_MASK = Short.MIN_VALUE;
    static final int MAX_TERM_LENGTH_UTF8 = 32766;

    void abort() {
        this.aborted = true;
        this.pendingNumDocs.addAndGet(-this.numDocsInRAM);
        try {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "now abort");
            }
            try {
                this.consumer.abort();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.pendingUpdates.clear();
        }
        finally {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "done abort");
            }
        }
    }

    public DocumentsWriterPerThread(IndexWriter writer, String segmentName, Directory directoryOrig, Directory directory, LiveIndexWriterConfig indexWriterConfig, InfoStream infoStream, DocumentsWriterDeleteQueue deleteQueue, FieldInfos.Builder fieldInfos, AtomicLong pendingNumDocs, boolean enableTestPoints) throws IOException {
        this.indexWriter = writer;
        this.directoryOrig = directoryOrig;
        this.directory = new TrackingDirectoryWrapper(directory);
        this.fieldInfos = fieldInfos;
        this.indexWriterConfig = indexWriterConfig;
        this.infoStream = infoStream;
        this.codec = indexWriterConfig.getCodec();
        this.docState = new DocState(this, infoStream);
        this.docState.similarity = indexWriterConfig.getSimilarity();
        this.pendingNumDocs = pendingNumDocs;
        this.bytesUsed = Counter.newCounter();
        this.byteBlockAllocator = new ByteBlockPool.DirectTrackingAllocator(this.bytesUsed);
        this.pendingUpdates = new BufferedUpdates(segmentName);
        this.intBlockAllocator = new IntBlockAllocator(this.bytesUsed);
        this.deleteQueue = deleteQueue;
        assert (this.numDocsInRAM == 0) : "num docs " + this.numDocsInRAM;
        this.deleteSlice = deleteQueue.newSlice();
        this.segmentInfo = new SegmentInfo(directoryOrig, Version.LATEST, Version.LATEST, segmentName, -1, false, this.codec, Collections.emptyMap(), StringHelper.randomId(), new HashMap<String, String>(), indexWriterConfig.getIndexSort());
        assert (this.numDocsInRAM == 0);
        this.consumer = indexWriterConfig.getIndexingChain().getChain(this);
        this.enableTestPoints = enableTestPoints;
    }

    public FieldInfos.Builder getFieldInfosBuilder() {
        return this.fieldInfos;
    }

    public int getIndexCreatedVersionMajor() {
        return this.indexWriter.segmentInfos.getIndexCreatedVersionMajor();
    }

    final void testPoint(String message) {
        if (this.enableTestPoints) {
            assert (this.infoStream.isEnabled("TP"));
            this.infoStream.message("TP", message);
        }
    }

    private void reserveOneDoc() {
        if (this.pendingNumDocs.incrementAndGet() > (long)IndexWriter.getActualMaxDocs()) {
            this.pendingNumDocs.decrementAndGet();
            throw new IllegalArgumentException("number of documents in the index cannot exceed " + IndexWriter.getActualMaxDocs());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateDocument(Iterable<? extends IndexableField> doc, Analyzer analyzer, Term delTerm) throws IOException, AbortingException {
        this.testPoint("DocumentsWriterPerThread addDocument start");
        assert (this.deleteQueue != null);
        this.reserveOneDoc();
        this.docState.doc = doc;
        this.docState.analyzer = analyzer;
        this.docState.docID = this.numDocsInRAM++;
        boolean success = false;
        try {
            try {
                this.consumer.processDocument();
            }
            finally {
                this.docState.clear();
            }
            success = true;
        }
        finally {
            if (!success) {
                this.deleteDocID(this.docState.docID);
            }
        }
        return this.finishDocument(delTerm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs, Analyzer analyzer, Term delTerm) throws IOException, AbortingException {
        this.testPoint("DocumentsWriterPerThread addDocuments start");
        assert (this.deleteQueue != null);
        this.docState.analyzer = analyzer;
        int docCount = 0;
        boolean allDocsIndexed = false;
        try {
            for (Iterable<? extends IndexableField> iterable : docs) {
                this.reserveOneDoc();
                this.docState.doc = iterable;
                this.docState.docID = this.numDocsInRAM++;
                ++docCount;
                boolean success = false;
                try {
                    this.consumer.processDocument();
                    success = true;
                }
                finally {
                    if (!success) {
                        // empty if block
                    }
                }
                ++this.numDocsInRAM;
            }
            allDocsIndexed = true;
            if (delTerm != null) {
                long seqNo = this.deleteQueue.add(delTerm, this.deleteSlice);
                assert (this.deleteSlice.isTailItem(delTerm)) : "expected the delete term as the tail item";
                this.deleteSlice.apply(this.pendingUpdates, this.numDocsInRAM - docCount);
                long l = seqNo;
                return l;
            }
            long seqNo = this.deleteQueue.updateSlice(this.deleteSlice);
            if (seqNo < 0L) {
                seqNo = -seqNo;
                this.deleteSlice.apply(this.pendingUpdates, this.numDocsInRAM - docCount);
            } else {
                this.deleteSlice.reset();
            }
            long l = seqNo;
            return l;
        }
        finally {
            if (!allDocsIndexed && !this.aborted) {
                int docID;
                int endDocID = docID - docCount;
                for (docID = this.numDocsInRAM - 1; docID > endDocID; --docID) {
                    this.deleteDocID(docID);
                }
            }
            this.docState.clear();
        }
    }

    private long finishDocument(Term delTerm) {
        long seqNo;
        boolean applySlice;
        boolean bl = applySlice = this.numDocsInRAM != 0;
        if (delTerm != null) {
            seqNo = this.deleteQueue.add(delTerm, this.deleteSlice);
            assert (this.deleteSlice.isTailItem(delTerm)) : "expected the delete term as the tail item";
        } else {
            seqNo = this.deleteQueue.updateSlice(this.deleteSlice);
            if (seqNo < 0L) {
                seqNo = -seqNo;
            } else {
                applySlice = false;
            }
        }
        if (applySlice) {
            this.deleteSlice.apply(this.pendingUpdates, this.numDocsInRAM);
        } else {
            this.deleteSlice.reset();
        }
        ++this.numDocsInRAM;
        return seqNo;
    }

    void deleteDocID(int docIDUpto) {
        this.pendingUpdates.addDocID(docIDUpto);
    }

    public int numDeleteTerms() {
        return this.pendingUpdates.numTermDeletes.get();
    }

    public int getNumDocsInRAM() {
        return this.numDocsInRAM;
    }

    FrozenBufferedUpdates prepareFlush() throws IOException {
        assert (this.numDocsInRAM > 0);
        FrozenBufferedUpdates globalUpdates = this.deleteQueue.freezeGlobalBuffer(this.deleteSlice);
        if (this.deleteSlice != null) {
            this.deleteSlice.apply(this.pendingUpdates, this.numDocsInRAM);
            assert (this.deleteSlice.isEmpty());
            this.deleteSlice.reset();
        }
        return globalUpdates;
    }

    FlushedSegment flush() throws IOException, AbortingException {
        assert (this.numDocsInRAM > 0);
        assert (this.deleteSlice.isEmpty()) : "all deletes must be applied in prepareFlush";
        this.segmentInfo.setMaxDoc(this.numDocsInRAM);
        SegmentWriteState flushState = new SegmentWriteState(this.infoStream, this.directory, this.segmentInfo, this.fieldInfos.finish(), this.pendingUpdates, new IOContext(new FlushInfo(this.numDocsInRAM, this.bytesUsed())));
        double startMBUsed = (double)this.bytesUsed() / 1024.0 / 1024.0;
        if (this.pendingUpdates.deleteDocIDs.size() > 0) {
            flushState.liveDocs = this.codec.liveDocsFormat().newLiveDocs(this.numDocsInRAM);
            for (int delDocID : this.pendingUpdates.deleteDocIDs) {
                flushState.liveDocs.clear(delDocID);
            }
            flushState.delCountOnFlush = this.pendingUpdates.deleteDocIDs.size();
            this.pendingUpdates.bytesUsed.addAndGet(-this.pendingUpdates.deleteDocIDs.size() * BufferedUpdates.BYTES_PER_DEL_DOCID);
            this.pendingUpdates.deleteDocIDs.clear();
        }
        if (this.aborted) {
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "flush: skip because aborting is set");
            }
            return null;
        }
        long t0 = System.nanoTime();
        if (this.infoStream.isEnabled("DWPT")) {
            this.infoStream.message("DWPT", "flush postings as segment " + flushState.segmentInfo.name + " numDocs=" + this.numDocsInRAM);
        }
        try {
            BufferedUpdates segmentDeletes;
            Sorter.DocMap sortMap = this.consumer.flush(flushState);
            this.pendingUpdates.clearDeleteTerms();
            this.segmentInfo.setFiles(new HashSet<String>(this.directory.getCreatedFiles()));
            SegmentCommitInfo segmentInfoPerCommit = new SegmentCommitInfo(this.segmentInfo, 0, -1L, -1L, -1L);
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "new segment has " + (flushState.liveDocs == null ? 0 : flushState.delCountOnFlush) + " deleted docs");
                this.infoStream.message("DWPT", "new segment has " + (flushState.fieldInfos.hasVectors() ? "vectors" : "no vectors") + "; " + (flushState.fieldInfos.hasNorms() ? "norms" : "no norms") + "; " + (flushState.fieldInfos.hasDocValues() ? "docValues" : "no docValues") + "; " + (flushState.fieldInfos.hasProx() ? "prox" : "no prox") + "; " + (flushState.fieldInfos.hasFreq() ? "freqs" : "no freqs"));
                this.infoStream.message("DWPT", "flushedFiles=" + segmentInfoPerCommit.files());
                this.infoStream.message("DWPT", "flushed codec=" + this.codec);
            }
            if (this.pendingUpdates.deleteQueries.isEmpty() && this.pendingUpdates.numericUpdates.isEmpty() && this.pendingUpdates.binaryUpdates.isEmpty()) {
                this.pendingUpdates.clear();
                segmentDeletes = null;
            } else {
                segmentDeletes = this.pendingUpdates;
            }
            if (this.infoStream.isEnabled("DWPT")) {
                double newSegmentSize = (double)segmentInfoPerCommit.sizeInBytes() / 1024.0 / 1024.0;
                this.infoStream.message("DWPT", "flushed: segment=" + this.segmentInfo.name + " ramUsed=" + this.nf.format(startMBUsed) + " MB newFlushedSize=" + this.nf.format(newSegmentSize) + " MB docs/MB=" + this.nf.format((double)flushState.segmentInfo.maxDoc() / newSegmentSize));
            }
            assert (this.segmentInfo != null);
            FlushedSegment fs = new FlushedSegment(this.infoStream, segmentInfoPerCommit, flushState.fieldInfos, segmentDeletes, flushState.liveDocs, flushState.delCountOnFlush, sortMap);
            this.sealFlushedSegment(fs, sortMap);
            if (this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "flush time " + (double)(System.nanoTime() - t0) / 1000000.0 + " msec");
            }
            return fs;
        }
        catch (Throwable th) {
            this.abort();
            throw AbortingException.wrap(th);
        }
    }

    public Set<String> pendingFilesToDelete() {
        return this.filesToDelete;
    }

    private MutableBits sortLiveDocs(Bits liveDocs, Sorter.DocMap sortMap) throws IOException {
        assert (liveDocs != null && sortMap != null);
        MutableBits sortedLiveDocs = this.codec.liveDocsFormat().newLiveDocs(liveDocs.length());
        for (int i = 0; i < liveDocs.length(); ++i) {
            if (liveDocs.get(i)) continue;
            sortedLiveDocs.clear(sortMap.oldToNew(i));
        }
        return sortedLiveDocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sealFlushedSegment(FlushedSegment flushedSegment, Sorter.DocMap sortMap) throws IOException {
        assert (flushedSegment != null);
        SegmentCommitInfo newSegment = flushedSegment.segmentInfo;
        IndexWriter.setDiagnostics(newSegment.info, "flush");
        IOContext context = new IOContext(new FlushInfo(newSegment.info.maxDoc(), newSegment.sizeInBytes()));
        boolean success = false;
        try {
            if (this.indexWriterConfig.getUseCompoundFile()) {
                Set<String> originalFiles = newSegment.info.files();
                this.indexWriter.createCompoundFile(this.infoStream, new TrackingDirectoryWrapper(this.directory), newSegment.info, context);
                this.filesToDelete.addAll(originalFiles);
                newSegment.info.setUseCompoundFile(true);
            }
            this.codec.segmentInfoFormat().write(this.directory, newSegment.info, context);
            if (flushedSegment.liveDocs != null) {
                int delCount = flushedSegment.delCount;
                assert (delCount > 0);
                if (this.infoStream.isEnabled("DWPT")) {
                    this.infoStream.message("DWPT", "flush: write " + delCount + " deletes gen=" + flushedSegment.segmentInfo.getDelGen());
                }
                SegmentCommitInfo info = flushedSegment.segmentInfo;
                Codec codec = info.info.getCodec();
                MutableBits bits = sortMap == null ? flushedSegment.liveDocs : this.sortLiveDocs(flushedSegment.liveDocs, sortMap);
                codec.liveDocsFormat().writeLiveDocs(bits, this.directory, info, delCount, context);
                newSegment.setDelCount(delCount);
                newSegment.advanceDelGen();
            }
            success = true;
        }
        finally {
            if (!success && this.infoStream.isEnabled("DWPT")) {
                this.infoStream.message("DWPT", "hit exception creating compound file for newly flushed segment " + newSegment.info.name);
            }
        }
    }

    SegmentInfo getSegmentInfo() {
        return this.segmentInfo;
    }

    long bytesUsed() {
        return this.bytesUsed.get() + this.pendingUpdates.bytesUsed.get();
    }

    public String toString() {
        return "DocumentsWriterPerThread [pendingDeletes=" + this.pendingUpdates + ", segment=" + (this.segmentInfo != null ? this.segmentInfo.name : "null") + ", aborted=" + this.aborted + ", numDocsInRAM=" + this.numDocsInRAM + ", deleteQueue=" + this.deleteQueue + "]";
    }

    private static class IntBlockAllocator
    extends IntBlockPool.Allocator {
        private final Counter bytesUsed;

        public IntBlockAllocator(Counter bytesUsed) {
            super(8192);
            this.bytesUsed = bytesUsed;
        }

        @Override
        public int[] getIntBlock() {
            int[] b = new int[8192];
            this.bytesUsed.addAndGet(32768L);
            return b;
        }

        @Override
        public void recycleIntBlocks(int[][] blocks, int offset, int length) {
            this.bytesUsed.addAndGet(-(length * 32768));
        }
    }

    static class FlushedSegment {
        final SegmentCommitInfo segmentInfo;
        final FieldInfos fieldInfos;
        final FrozenBufferedUpdates segmentUpdates;
        final MutableBits liveDocs;
        final Sorter.DocMap sortMap;
        final int delCount;

        private FlushedSegment(InfoStream infoStream, SegmentCommitInfo segmentInfo, FieldInfos fieldInfos, BufferedUpdates segmentUpdates, MutableBits liveDocs, int delCount, Sorter.DocMap sortMap) throws IOException {
            this.segmentInfo = segmentInfo;
            this.fieldInfos = fieldInfos;
            this.segmentUpdates = segmentUpdates != null && segmentUpdates.any() ? new FrozenBufferedUpdates(infoStream, segmentUpdates, segmentInfo) : null;
            this.liveDocs = liveDocs;
            this.delCount = delCount;
            this.sortMap = sortMap;
        }
    }

    static class DocState {
        final DocumentsWriterPerThread docWriter;
        Analyzer analyzer;
        InfoStream infoStream;
        Similarity similarity;
        int docID;
        Iterable<? extends IndexableField> doc;

        DocState(DocumentsWriterPerThread docWriter, InfoStream infoStream) {
            this.docWriter = docWriter;
            this.infoStream = infoStream;
        }

        public void testPoint(String name) {
            this.docWriter.testPoint(name);
        }

        public void clear() {
            this.doc = null;
            this.analyzer = null;
        }
    }

    static abstract class IndexingChain {
        IndexingChain() {
        }

        abstract DocConsumer getChain(DocumentsWriterPerThread var1) throws IOException;
    }
}

