/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc.net.client;

import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.main.MainResponse;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.sql.client.HttpClient;
import org.elasticsearch.xpack.sql.jdbc.jdbc.JdbcConfiguration;
import org.elasticsearch.xpack.sql.jdbc.net.client.Cursor;
import org.elasticsearch.xpack.sql.jdbc.net.client.DefaultCursor;
import org.elasticsearch.xpack.sql.jdbc.net.client.RequestMeta;
import org.elasticsearch.xpack.sql.jdbc.net.protocol.InfoResponse;
import org.elasticsearch.xpack.sql.plugin.AbstractSqlQueryRequest;
import org.elasticsearch.xpack.sql.plugin.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.plugin.ColumnInfo;
import org.elasticsearch.xpack.sql.plugin.SqlQueryRequest;
import org.elasticsearch.xpack.sql.plugin.SqlQueryResponse;
import org.elasticsearch.xpack.sql.plugin.SqlTypedParamValue;

public class JdbcHttpClient {
    private final HttpClient httpClient;
    private final JdbcConfiguration conCfg;
    private InfoResponse serverInfo;

    public JdbcHttpClient(JdbcConfiguration conCfg) throws SQLException {
        this.httpClient = new HttpClient(conCfg);
        this.conCfg = conCfg;
    }

    public boolean ping(long timeoutInMs) throws SQLException {
        return this.httpClient.ping(timeoutInMs);
    }

    public Cursor query(String sql, List<SqlTypedParamValue> params, RequestMeta meta) throws SQLException {
        int fetch = meta.fetchSize() > 0 ? meta.fetchSize() : this.conCfg.pageSize();
        SqlQueryRequest sqlRequest = new SqlQueryRequest(AbstractSqlRequest.Mode.JDBC, sql, params, null, AbstractSqlQueryRequest.DEFAULT_TIME_ZONE, fetch, TimeValue.timeValueMillis((long)meta.timeoutInMs()), TimeValue.timeValueMillis((long)meta.queryTimeoutInMs()), "");
        SqlQueryResponse response = this.httpClient.query(sqlRequest);
        return new DefaultCursor(this, response.cursor(), this.toJdbcColumnInfo(response.columns()), response.rows(), meta);
    }

    public Tuple<String, List<List<Object>>> nextPage(String cursor, RequestMeta meta) throws SQLException {
        SqlQueryRequest sqlRequest = new SqlQueryRequest().cursor(cursor);
        sqlRequest.mode(AbstractSqlRequest.Mode.JDBC);
        sqlRequest.requestTimeout(TimeValue.timeValueMillis((long)meta.timeoutInMs()));
        sqlRequest.pageTimeout(TimeValue.timeValueMillis((long)meta.queryTimeoutInMs()));
        SqlQueryResponse response = this.httpClient.query(sqlRequest);
        return new Tuple((Object)response.cursor(), response.rows());
    }

    public boolean queryClose(String cursor) throws SQLException {
        return this.httpClient.queryClose(cursor);
    }

    public InfoResponse serverInfo() throws SQLException {
        if (this.serverInfo == null) {
            this.serverInfo = this.fetchServerInfo();
        }
        return this.serverInfo;
    }

    private InfoResponse fetchServerInfo() throws SQLException {
        MainResponse mainResponse = this.httpClient.serverInfo();
        return new InfoResponse(mainResponse.getClusterName().value(), mainResponse.getVersion().major, mainResponse.getVersion().minor);
    }

    private List<org.elasticsearch.xpack.sql.jdbc.net.protocol.ColumnInfo> toJdbcColumnInfo(List<ColumnInfo> columns) {
        return columns.stream().map(columnInfo -> new org.elasticsearch.xpack.sql.jdbc.net.protocol.ColumnInfo(columnInfo.name(), columnInfo.jdbcType(), "", "", "", "", columnInfo.displaySize())).collect(Collectors.toList());
    }
}

