/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc.jdbcx;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Wrapper;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.elasticsearch.xpack.sql.client.shared.Version;
import org.elasticsearch.xpack.sql.jdbc.debug.Debug;
import org.elasticsearch.xpack.sql.jdbc.jdbc.JdbcConfiguration;
import org.elasticsearch.xpack.sql.jdbc.jdbc.JdbcConnection;

public class JdbcDataSource
implements DataSource,
Wrapper {
    private String url;
    private PrintWriter writer;
    private int loginTimeout;
    private Properties props;

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.writer;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.writer = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new SQLException("Negative timeout specified " + seconds);
        }
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Properties getProperties() {
        Properties copy = new Properties();
        if (this.props != null) {
            copy.putAll((Map<?, ?>)this.props);
        }
        return copy;
    }

    public void setProperties(Properties props) {
        this.props = new Properties();
        this.props.putAll((Map<?, ?>)props);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.doGetConnection(this.getProperties());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Properties p = this.getProperties();
        p.setProperty("user", username);
        p.setProperty("password", password);
        return this.doGetConnection(p);
    }

    private Connection doGetConnection(Properties p) throws SQLException {
        JdbcConfiguration cfg = JdbcConfiguration.create(this.url, p, this.loginTimeout);
        JdbcConnection con = new JdbcConnection(cfg);
        return cfg.debug() ? Debug.proxy(cfg, con, this.writer) : con;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException();
    }

    static {
        Version.CURRENT.toString();
    }
}

