/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc.jdbc;

import java.net.URI;
import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.xpack.sql.client.shared.ConnectionConfiguration;
import org.elasticsearch.xpack.sql.client.shared.StringUtils;
import org.elasticsearch.xpack.sql.client.shared.UriUtils;
import org.elasticsearch.xpack.sql.client.shared.Version;
import org.elasticsearch.xpack.sql.jdbc.JdbcSQLException;

public class JdbcConfiguration
extends ConnectionConfiguration {
    static final String URL_PREFIX = "jdbc:es://";
    public static URI DEFAULT_URI = URI.create("http://localhost:9200/");
    static final String DEBUG = "debug";
    static final String DEBUG_DEFAULT = "false";
    static final String DEBUG_OUTPUT = "debug.output";
    static final String DEBUG_OUTPUT_DEFAULT = "err";
    public static final String TIME_ZONE = "timezone";
    static final String TIME_ZONE_DEFAULT = TimeZone.getDefault().getID();
    private static final Set<String> OPTION_NAMES = new LinkedHashSet<String>(Arrays.asList("timezone", "debug", "debug.output"));
    private final String originalUrl;
    private final boolean debug;
    private final String debugOut;
    private TimeZone timeZone;

    public static JdbcConfiguration create(String u, Properties props, int loginTimeoutSeconds) throws JdbcSQLException {
        URI uri = JdbcConfiguration.parseUrl(u);
        Properties urlProps = JdbcConfiguration.parseProperties(uri, u);
        uri = UriUtils.removeQuery(uri, u, DEFAULT_URI);
        if (props != null) {
            urlProps.putAll((Map<?, ?>)props);
        }
        if (loginTimeoutSeconds > 0) {
            urlProps.setProperty("connect.timeout", Long.toString(TimeUnit.SECONDS.toMillis(loginTimeoutSeconds)));
        }
        try {
            return new JdbcConfiguration(uri, u, urlProps);
        }
        catch (JdbcSQLException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new JdbcSQLException(ex, ex.getMessage());
        }
    }

    private static URI parseUrl(String u) throws JdbcSQLException {
        String url = u;
        String format = "jdbc:es://[http|https]?[host[:port]]*/[prefix]*[?[option=value]&]*";
        if (!JdbcConfiguration.canAccept(u)) {
            throw new JdbcSQLException("Expected [jdbc:es://] url, received [" + u + "]");
        }
        try {
            return UriUtils.parseURI(JdbcConfiguration.removeJdbcPrefix(u), DEFAULT_URI);
        }
        catch (IllegalArgumentException ex) {
            throw new JdbcSQLException(ex, "Invalid URL [" + url + "], format should be [" + format + "]");
        }
    }

    private static String removeJdbcPrefix(String connectionString) throws JdbcSQLException {
        if (connectionString.startsWith(URL_PREFIX)) {
            return connectionString.substring(URL_PREFIX.length());
        }
        throw new JdbcSQLException("Expected [jdbc:es://] url, received [" + connectionString + "]");
    }

    private static Properties parseProperties(URI uri, String u) throws JdbcSQLException {
        Properties props = new Properties();
        try {
            if (uri.getRawQuery() != null) {
                List<String> prms = StringUtils.tokenize(uri.getRawQuery(), "&");
                for (String param : prms) {
                    List<String> args = StringUtils.tokenize(param, "=");
                    if (args.size() != 2) {
                        throw new JdbcSQLException("Invalid parameter [" + param + "], format needs to be key=value");
                    }
                    props.setProperty(args.get(0).trim(), args.get(1).trim());
                }
            }
        }
        catch (JdbcSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse acceptable jdbc url [" + u + "]", e);
        }
        return props;
    }

    private JdbcConfiguration(URI baseURI, String u, Properties props) throws JdbcSQLException {
        super(baseURI, u, props);
        this.originalUrl = u;
        this.debug = this.parseValue(DEBUG, props.getProperty(DEBUG, DEBUG_DEFAULT), Boolean::parseBoolean);
        this.debugOut = props.getProperty(DEBUG_OUTPUT, DEBUG_OUTPUT_DEFAULT);
        this.timeZone = this.parseValue(TIME_ZONE, props.getProperty(TIME_ZONE, TIME_ZONE_DEFAULT), TimeZone::getTimeZone);
    }

    @Override
    protected Collection<? extends String> extraOptions() {
        return OPTION_NAMES;
    }

    public boolean debug() {
        return this.debug;
    }

    public String debugOut() {
        return this.debugOut;
    }

    public TimeZone timeZone() {
        return this.timeZone;
    }

    public void timeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public static boolean canAccept(String url) {
        return StringUtils.hasText(url) && url.trim().startsWith(URL_PREFIX);
    }

    public DriverPropertyInfo[] driverPropertyInfo() {
        ArrayList<DriverPropertyInfo> info = new ArrayList<DriverPropertyInfo>();
        for (String option : OPTION_NAMES) {
            String value = null;
            DriverPropertyInfo prop = new DriverPropertyInfo(option, value);
            info.add(prop);
        }
        return info.toArray(new DriverPropertyInfo[info.size()]);
    }

    static {
        Version.CURRENT.toString();
    }
}

