/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc.net.client;

import java.sql.SQLException;
import java.util.List;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.xpack.sql.jdbc.net.client.Cursor;
import org.elasticsearch.xpack.sql.jdbc.net.client.JdbcHttpClient;
import org.elasticsearch.xpack.sql.jdbc.net.client.RequestMeta;
import org.elasticsearch.xpack.sql.jdbc.net.protocol.ColumnInfo;

class DefaultCursor
implements Cursor {
    private final JdbcHttpClient client;
    private final RequestMeta meta;
    private final List<ColumnInfo> columnInfos;
    private List<List<Object>> rows;
    private int row = -1;
    private String cursor;

    DefaultCursor(JdbcHttpClient client, String cursor, List<ColumnInfo> columnInfos, List<List<Object>> rows, RequestMeta meta) {
        this.client = client;
        this.meta = meta;
        this.cursor = cursor;
        this.columnInfos = columnInfos;
        this.rows = rows;
    }

    @Override
    public List<ColumnInfo> columns() {
        return this.columnInfos;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.row < this.rows.size() - 1) {
            ++this.row;
            return true;
        }
        if (!this.cursor.isEmpty()) {
            Tuple<String, List<List<Object>>> nextPage = this.client.nextPage(this.cursor, this.meta);
            this.cursor = (String)nextPage.v1();
            this.rows = (List)nextPage.v2();
            this.row = -1;
            return this.next();
        }
        return false;
    }

    @Override
    public Object column(int column) {
        return this.rows.get(this.row).get(column);
    }

    @Override
    public int batchSize() {
        return this.rows.size();
    }

    @Override
    public void close() throws SQLException {
        if (!this.cursor.isEmpty()) {
            this.client.queryClose(this.cursor);
        }
    }
}

