/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc.jdbc;

import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.xpack.sql.jdbc.JdbcSQLException;
import org.elasticsearch.xpack.sql.type.DataType;

final class TypeConverter {
    private static final long DAY_IN_MILLIS = 86400L;

    private TypeConverter() {
    }

    static Date convertDate(Long millis, Calendar cal) {
        return TypeConverter.dateTimeConvert(millis, cal, c -> {
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            return new Date(c.getTimeInMillis());
        });
    }

    static Time convertTime(Long millis, Calendar cal) {
        return TypeConverter.dateTimeConvert(millis, cal, c -> {
            c.set(0, 1);
            c.set(1, 1970);
            c.set(2, 0);
            c.set(5, 1);
            return new Time(c.getTimeInMillis());
        });
    }

    static Timestamp convertTimestamp(Long millis, Calendar cal) {
        return TypeConverter.dateTimeConvert(millis, cal, c -> new Timestamp(c.getTimeInMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T dateTimeConvert(Long millis, Calendar c, Function<Calendar, T> creator) {
        if (millis == null) {
            return null;
        }
        long initial = c.getTimeInMillis();
        try {
            c.setTimeInMillis(millis);
            T t = creator.apply(c);
            return t;
        }
        finally {
            c.setTimeInMillis(initial);
        }
    }

    static <T> T convert(Object val, JDBCType columnType, Class<T> type) throws SQLException {
        if (type == null) {
            return (T)TypeConverter.convert(val, columnType);
        }
        if (type == String.class) {
            return (T)TypeConverter.asString(TypeConverter.convert(val, columnType));
        }
        if (type == Boolean.class) {
            return (T)TypeConverter.asBoolean(val, columnType);
        }
        if (type == Byte.class) {
            return (T)TypeConverter.asByte(val, columnType);
        }
        if (type == Short.class) {
            return (T)TypeConverter.asShort(val, columnType);
        }
        if (type == Integer.class) {
            return (T)TypeConverter.asInteger(val, columnType);
        }
        if (type == Long.class) {
            return (T)TypeConverter.asLong(val, columnType);
        }
        if (type == Float.class) {
            return (T)TypeConverter.asFloat(val, columnType);
        }
        if (type == Double.class) {
            return (T)TypeConverter.asDouble(val, columnType);
        }
        if (type == Date.class) {
            return (T)TypeConverter.asDate(val, columnType);
        }
        if (type == Time.class) {
            return (T)TypeConverter.asTime(val, columnType);
        }
        if (type == Timestamp.class) {
            return (T)TypeConverter.asTimestamp(val, columnType);
        }
        if (type == byte[].class) {
            return (T)TypeConverter.asByteArray(val, columnType);
        }
        if (type == LocalDate.class) {
            return (T)TypeConverter.asLocalDate(val, columnType);
        }
        if (type == LocalTime.class) {
            return (T)TypeConverter.asLocalTime(val, columnType);
        }
        if (type == LocalDateTime.class) {
            return (T)TypeConverter.asLocalDateTime(val, columnType);
        }
        if (type == OffsetTime.class) {
            return (T)TypeConverter.asOffsetTime(val, columnType);
        }
        if (type == OffsetDateTime.class) {
            return (T)TypeConverter.asOffsetDateTime(val, columnType);
        }
        throw new SQLException("Conversion from type [" + columnType + "] to [" + type.getName() + "] not supported");
    }

    public static String classNameOf(JDBCType jdbcType) throws JdbcSQLException {
        DataType dataType;
        try {
            dataType = DataType.fromJdbcType(jdbcType);
        }
        catch (IllegalArgumentException ex) {
            throw new JdbcSQLException(ex, ex.getMessage());
        }
        if (dataType.javaName == null) {
            throw new JdbcSQLException("Unsupported JDBC type [" + jdbcType + "]");
        }
        return dataType.javaName;
    }

    static Object convert(Object v, JDBCType columnType) throws SQLException {
        switch (columnType) {
            case NULL: {
                return null;
            }
            case BOOLEAN: 
            case VARCHAR: {
                return v;
            }
            case TINYINT: {
                return ((Number)v).byteValue();
            }
            case SMALLINT: {
                return ((Number)v).shortValue();
            }
            case INTEGER: {
                return ((Number)v).intValue();
            }
            case BIGINT: {
                return ((Number)v).longValue();
            }
            case FLOAT: 
            case DOUBLE: {
                return TypeConverter.doubleValue(v);
            }
            case REAL: {
                return TypeConverter.floatValue(v);
            }
            case TIMESTAMP: {
                return new Timestamp(((Number)v).longValue());
            }
        }
        throw new SQLException("Unexpected column type [" + columnType.getName() + "]");
    }

    static boolean isSigned(JDBCType jdbcType) throws SQLException {
        DataType dataType;
        try {
            dataType = DataType.fromJdbcType(jdbcType);
        }
        catch (IllegalArgumentException ex) {
            throw new JdbcSQLException(ex, ex.getMessage());
        }
        return dataType.isSigned();
    }

    private static Double doubleValue(Object v) {
        if (v instanceof String) {
            switch ((String)v) {
                case "NaN": {
                    return Double.NaN;
                }
                case "Infinity": {
                    return Double.POSITIVE_INFINITY;
                }
                case "-Infinity": {
                    return Double.NEGATIVE_INFINITY;
                }
            }
            return Double.parseDouble((String)v);
        }
        return ((Number)v).doubleValue();
    }

    private static Float floatValue(Object v) {
        if (v instanceof String) {
            switch ((String)v) {
                case "NaN": {
                    return Float.valueOf(Float.NaN);
                }
                case "Infinity": {
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case "-Infinity": {
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
            }
            return Float.valueOf(Float.parseFloat((String)v));
        }
        return Float.valueOf(((Number)v).floatValue());
    }

    private static String asString(Object nativeValue) {
        return nativeValue == null ? null : String.valueOf(nativeValue);
    }

    private static Boolean asBoolean(Object val, JDBCType columnType) throws SQLException {
        switch (columnType) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case REAL: {
                return Integer.signum(((Number)val).intValue()) == 0;
            }
        }
        throw new SQLException("Conversion from type [" + columnType + "] to [Boolean] not supported");
    }

    private static Byte asByte(Object val, JDBCType columnType) throws SQLException {
        switch (columnType) {
            case BOOLEAN: {
                return (Boolean)val != false ? (byte)1 : 0;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return TypeConverter.safeToByte(((Number)val).longValue());
            }
            case FLOAT: 
            case DOUBLE: 
            case REAL: {
                return TypeConverter.safeToByte(TypeConverter.safeToLong(((Number)val).doubleValue()));
            }
        }
        throw new SQLException("Conversion from type [" + columnType + "] to [Byte] not supported");
    }

    private static Short asShort(Object val, JDBCType columnType) throws SQLException {
        switch (columnType) {
            case BOOLEAN: {
                return (Boolean)val != false ? (short)1 : 0;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return TypeConverter.safeToShort(((Number)val).longValue());
            }
            case FLOAT: 
            case DOUBLE: 
            case REAL: {
                return TypeConverter.safeToShort(TypeConverter.safeToLong(((Number)val).doubleValue()));
            }
        }
        throw new SQLException("Conversion from type [" + columnType + "] to [Short] not supported");
    }

    private static Integer asInteger(Object val, JDBCType columnType) throws SQLException {
        switch (columnType) {
            case BOOLEAN: {
                return (Boolean)val != false ? 1 : 0;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return TypeConverter.safeToInt(((Number)val).longValue());
            }
            case FLOAT: 
            case DOUBLE: 
            case REAL: {
                return TypeConverter.safeToInt(TypeConverter.safeToLong(((Number)val).doubleValue()));
            }
        }
        throw new SQLException("Conversion from type [" + columnType + "] to [Integer] not supported");
    }

    private static Long asLong(Object val, JDBCType columnType) throws SQLException {
        switch (columnType) {
            case BOOLEAN: {
                return (Boolean)val != false ? 1L : 0L;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return ((Number)val).longValue();
            }
            case FLOAT: 
            case DOUBLE: 
            case REAL: {
                return TypeConverter.safeToLong(((Number)val).doubleValue());
            }
            case TIMESTAMP: {
                return ((Number)val).longValue();
            }
        }
        throw new SQLException("Conversion from type [" + columnType + "] to [Long] not supported");
    }

    private static Float asFloat(Object val, JDBCType columnType) throws SQLException {
        switch (columnType) {
            case BOOLEAN: {
                return Float.valueOf((Boolean)val != false ? 1.0f : 0.0f);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return Float.valueOf(((Number)val).longValue());
            }
            case FLOAT: 
            case DOUBLE: 
            case REAL: {
                return new Float(((Number)val).doubleValue());
            }
        }
        throw new SQLException("Conversion from type [" + columnType + "] to [Float] not supported");
    }

    private static Double asDouble(Object val, JDBCType columnType) throws SQLException {
        switch (columnType) {
            case BOOLEAN: {
                return (Boolean)val != false ? 1.0 : 0.0;
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return ((Number)val).longValue();
            }
            case FLOAT: 
            case DOUBLE: 
            case REAL: {
                return new Double(((Number)val).doubleValue());
            }
        }
        throw new SQLException("Conversion from type [" + columnType + "] to [Double] not supported");
    }

    private static Date asDate(Object val, JDBCType columnType) throws SQLException {
        if (columnType == JDBCType.TIMESTAMP) {
            return new Date(TypeConverter.utcMillisRemoveTime(((Number)val).longValue()));
        }
        throw new SQLException("Conversion from type [" + columnType + "] to [Date] not supported");
    }

    private static Time asTime(Object val, JDBCType columnType) throws SQLException {
        if (columnType == JDBCType.TIMESTAMP) {
            return new Time(TypeConverter.utcMillisRemoveDate(((Number)val).longValue()));
        }
        throw new SQLException("Conversion from type [" + columnType + "] to [Time] not supported");
    }

    private static Timestamp asTimestamp(Object val, JDBCType columnType) throws SQLException {
        if (columnType == JDBCType.TIMESTAMP) {
            return new Timestamp(((Number)val).longValue());
        }
        throw new SQLException("Conversion from type [" + columnType + "] to [Timestamp] not supported");
    }

    private static byte[] asByteArray(Object val, JDBCType columnType) {
        throw new UnsupportedOperationException();
    }

    private static LocalDate asLocalDate(Object val, JDBCType columnType) {
        throw new UnsupportedOperationException();
    }

    private static LocalTime asLocalTime(Object val, JDBCType columnType) {
        throw new UnsupportedOperationException();
    }

    private static LocalDateTime asLocalDateTime(Object val, JDBCType columnType) {
        throw new UnsupportedOperationException();
    }

    private static OffsetTime asOffsetTime(Object val, JDBCType columnType) {
        throw new UnsupportedOperationException();
    }

    private static OffsetDateTime asOffsetDateTime(Object val, JDBCType columnType) {
        throw new UnsupportedOperationException();
    }

    private static long utcMillisRemoveTime(long l) {
        return l - l % 86400L;
    }

    private static long utcMillisRemoveDate(long l) {
        return l % 86400L;
    }

    private static byte safeToByte(long x) throws SQLException {
        if (x > 127L || x < -128L) {
            throw new SQLException(String.format(Locale.ROOT, "Numeric %d out of range", Long.toString(x)));
        }
        return (byte)x;
    }

    private static short safeToShort(long x) throws SQLException {
        if (x > 32767L || x < -32768L) {
            throw new SQLException(String.format(Locale.ROOT, "Numeric %d out of range", Long.toString(x)));
        }
        return (short)x;
    }

    private static int safeToInt(long x) throws SQLException {
        if (x > Integer.MAX_VALUE || x < Integer.MIN_VALUE) {
            throw new SQLException(String.format(Locale.ROOT, "Numeric %d out of range", Long.toString(x)));
        }
        return (int)x;
    }

    private static long safeToLong(double x) throws SQLException {
        if (x > 9.223372036854776E18 || x < -9.223372036854776E18) {
            throw new SQLException(String.format(Locale.ROOT, "Numeric %d out of range", Double.toString(x)));
        }
        return Math.round(x);
    }
}

