/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc.jdbc;

import java.sql.SQLException;

public final class SqlQueryParameterAnalyzer {
    private SqlQueryParameterAnalyzer() {
    }

    public static int parametersCount(String sql) throws SQLException {
        int l = sql.length();
        int params = 0;
        block8: for (int i = 0; i < l; ++i) {
            char c = sql.charAt(i);
            switch (c) {
                case '{': {
                    i = SqlQueryParameterAnalyzer.skipJdbcEscape(i, sql);
                    continue block8;
                }
                case '\'': {
                    i = SqlQueryParameterAnalyzer.skipString(i, sql, c);
                    continue block8;
                }
                case '\"': {
                    i = SqlQueryParameterAnalyzer.skipString(i, sql, c);
                    continue block8;
                }
                case '?': {
                    ++params;
                    continue block8;
                }
                case '-': {
                    if (i + 1 >= l || sql.charAt(i + 1) != '-') continue block8;
                    i = SqlQueryParameterAnalyzer.skipLineComment(i, sql);
                    continue block8;
                }
                case '/': {
                    if (i + 1 >= l || sql.charAt(i + 1) != '*') continue block8;
                    i = SqlQueryParameterAnalyzer.skipMultiLineComment(i, sql);
                }
            }
        }
        return params;
    }

    private static int skipJdbcEscape(int i, String sql) throws SQLException {
        throw new SQLException("Jdbc escape sequences are not supported yet");
    }

    private static int skipLineComment(int i, String sql) {
        while (i < sql.length()) {
            char c = sql.charAt(i);
            if (c == '\n' || c == '\r') {
                return i;
            }
            ++i;
        }
        return i;
    }

    private static int skipMultiLineComment(int i, String sql) throws SQLException {
        int block = 0;
        while (i < sql.length() - 1) {
            char c = sql.charAt(i);
            if (c == '/' && sql.charAt(i + 1) == '*') {
                ++i;
                ++block;
            } else if (c == '*' && sql.charAt(i + 1) == '/') {
                ++i;
                --block;
            }
            if (block == 0) {
                return i;
            }
            ++i;
        }
        throw new SQLException("Cannot parse given sql; unclosed /* comment");
    }

    private static int skipString(int i, String sql, char q) throws SQLException {
        ++i;
        while (i < sql.length()) {
            char c = sql.charAt(i);
            if (c == q) {
                if (i + 1 < sql.length() && sql.charAt(i + 1) == q) {
                    ++i;
                } else {
                    return i;
                }
            }
            ++i;
        }
        throw new SQLException("Cannot parse given sql; unclosed string");
    }
}

