/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc.jdbc;

import java.sql.JDBCType;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.sql.jdbc.JdbcSQLException;
import org.elasticsearch.xpack.sql.jdbc.jdbc.SqlQueryParameterAnalyzer;
import org.elasticsearch.xpack.sql.plugin.SqlTypedParamValue;
import org.elasticsearch.xpack.sql.type.DataType;

class PreparedQuery {
    private final String sql;
    private final ParamInfo[] params;

    private PreparedQuery(String sql, int paramCount) {
        this.sql = sql;
        this.params = new ParamInfo[paramCount];
        this.clearParams();
    }

    ParamInfo getParam(int param) throws JdbcSQLException {
        if (param < 1 || param > this.params.length) {
            throw new JdbcSQLException("Invalid parameter index [" + param + "]");
        }
        return this.params[param - 1];
    }

    void setParam(int param, Object value, JDBCType type) throws JdbcSQLException {
        if (param < 1 || param > this.params.length) {
            throw new JdbcSQLException("Invalid parameter index [" + param + "]");
        }
        this.params[param - 1].value = value;
        this.params[param - 1].type = type;
    }

    int paramCount() {
        return this.params.length;
    }

    void clearParams() {
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i] = new ParamInfo(null, JDBCType.VARCHAR);
        }
    }

    String sql() {
        return this.sql;
    }

    List<SqlTypedParamValue> params() {
        return Arrays.stream(this.params).map(paramInfo -> new SqlTypedParamValue(paramInfo.value, DataType.fromJdbcType(paramInfo.type))).collect(Collectors.toList());
    }

    public String toString() {
        return this.sql() + " " + this.params();
    }

    static PreparedQuery prepare(String sql) throws SQLException {
        return new PreparedQuery(sql, SqlQueryParameterAnalyzer.parametersCount(sql));
    }

    static class ParamInfo {
        JDBCType type;
        Object value;

        ParamInfo(Object value, JDBCType type) {
            this.value = value;
            this.type = type;
        }
    }
}

