/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.xpack.sql.jdbc.debug.Debug;
import org.elasticsearch.xpack.sql.jdbc.jdbc.JdbcConfiguration;
import org.elasticsearch.xpack.sql.jdbc.jdbc.JdbcDatabaseMetaData;
import org.elasticsearch.xpack.sql.jdbc.jdbc.JdbcPreparedStatement;
import org.elasticsearch.xpack.sql.jdbc.jdbc.JdbcStatement;
import org.elasticsearch.xpack.sql.jdbc.jdbc.JdbcWrapper;
import org.elasticsearch.xpack.sql.jdbc.net.client.JdbcHttpClient;

public class JdbcConnection
implements Connection,
JdbcWrapper {
    private final String url;
    private final String userName;
    final JdbcConfiguration cfg;
    final JdbcHttpClient client;
    private boolean closed = false;
    private String catalog;
    private String schema;

    public JdbcConnection(JdbcConfiguration connectionInfo) throws SQLException {
        this.cfg = connectionInfo;
        this.client = new JdbcHttpClient(connectionInfo);
        this.url = connectionInfo.connectionString();
        this.userName = connectionInfo.authUser();
    }

    private void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkOpen();
        return new JdbcStatement(this, this.cfg);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        return new JdbcPreparedStatement(this, this.cfg, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Stored procedures not supported yet");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        if (!autoCommit) {
            new SQLFeatureNotSupportedException("Non auto-commit is not supported");
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        this.checkOpen();
        if (this.getAutoCommit()) {
            throw new SQLException("Auto-commit is enabled");
        }
        throw new SQLFeatureNotSupportedException("Commit/Rollback not supported");
    }

    @Override
    public void rollback() throws SQLException {
        this.checkOpen();
        if (this.getAutoCommit()) {
            throw new SQLException("Auto-commit is enabled");
        }
        throw new SQLFeatureNotSupportedException("Commit/Rollback not supported");
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.closed = true;
            Debug.release(this.cfg);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new JdbcDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (!readOnly) {
            throw new SQLFeatureNotSupportedException("Only read-only mode is supported");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        this.catalog = catalog;
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this.catalog;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        if (0 != level) {
            throw new SQLFeatureNotSupportedException("Transactions not supported");
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkResultSet(resultSetType, resultSetConcurrency);
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkResultSet(resultSetType, resultSetConcurrency);
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkResultSet(resultSetType, resultSetConcurrency);
        return this.prepareCall(sql);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("typeMap not supported");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("typeMap not supported");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkOpen();
        this.checkHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Savepoints not supported");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Savepoints not supported");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Savepoints not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Savepoints not supported");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        this.checkHoldability(resultSetHoldability);
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        this.checkHoldability(resultSetHoldability);
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkOpen();
        this.checkHoldability(resultSetHoldability);
        return this.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        if (autoGeneratedKeys != 2) {
            throw new SQLFeatureNotSupportedException("Auto generated keys must be NO_GENERATED_KEYS");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Autogenerated key not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Autogenerated key not supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Clob not supported yet");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Blob not supported yet");
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("NClob not supported yet");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("SQLXML not supported yet");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Negative timeout");
        }
        return !this.isClosed() && this.client.ping(TimeUnit.SECONDS.toMillis(timeout));
    }

    private void checkOpenClientInfo() throws SQLClientInfoException {
        if (this.isClosed()) {
            throw new SQLClientInfoException("Connection closed", null);
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.checkOpenClientInfo();
        throw new SQLClientInfoException("Unsupported operation", null);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.checkOpenClientInfo();
        throw new SQLClientInfoException("Unsupported operation", null);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkOpenClientInfo();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkOpenClientInfo();
        return new Properties();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Array not supported yet");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkOpen();
        throw new SQLFeatureNotSupportedException("Struct not supported yet");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.checkOpen();
        this.schema = schema;
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkOpen();
        return this.schema;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private void checkResultSet(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (1003 != resultSetType) {
            throw new SQLFeatureNotSupportedException("ResultSet type can only be TYPE_FORWARD_ONLY");
        }
        if (1007 != resultSetConcurrency) {
            throw new SQLFeatureNotSupportedException("ResultSet concurrency can only be CONCUR_READ_ONLY");
        }
    }

    private void checkHoldability(int resultSetHoldability) throws SQLException {
        if (1 != resultSetHoldability) {
            throw new SQLFeatureNotSupportedException("Holdability can only be HOLD_CURSORS_OVER_COMMIT");
        }
    }

    String getURL() {
        return this.url;
    }

    String getUserName() {
        return this.userName;
    }

    int esInfoMajorVersion() throws SQLException {
        return this.client.serverInfo().majorVersion;
    }

    int esInfoMinorVersion() throws SQLException {
        return this.client.serverInfo().minorVersion;
    }
}

