/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.jdbc.debug;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.elasticsearch.xpack.sql.jdbc.JdbcSQLException;
import org.elasticsearch.xpack.sql.jdbc.debug.DebugLog;
import org.elasticsearch.xpack.sql.jdbc.debug.DebugProxy;

abstract class DebuggingInvoker
implements InvocationHandler {
    private final Object target;
    protected final Object parent;
    final DebugLog log;

    DebuggingInvoker(DebugLog log, Object target, Object parent) {
        this.log = log;
        this.target = target;
        this.parent = parent;
    }

    @Override
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String name = method.getName();
        Class<?>[] params = method.getParameterTypes();
        if ("equals".equals(name) && params.length == 1 && params[0] == Object.class) {
            Object o = args[0];
            if (o == null || !(o instanceof DebugProxy)) {
                return Boolean.FALSE;
            }
            InvocationHandler ih = Proxy.getInvocationHandler(o);
            return ih instanceof DebuggingInvoker && this.target.equals(((DebuggingInvoker)ih).target);
        }
        if ("hashCode".equals(name) && params.length == 0) {
            return System.identityHashCode(proxy);
        }
        if ("toString".equals(name) && params.length == 0) {
            return "Debug proxy for " + this.target;
        }
        try {
            Object result = method.invoke(this.target, args);
            this.log.logResult(method, args, result);
            return result == null || result instanceof DebugProxy ? result : this.postProcess(result, proxy);
        }
        catch (InvocationTargetException ex) {
            this.log.logException(method, args, ex.getCause());
            throw ex.getCause();
        }
        catch (Exception ex) {
            this.log.logException(method, args, ex);
            throw new JdbcSQLException(ex, "Debugging failed for [" + method + "]");
        }
    }

    protected Object postProcess(Object result, Object proxy) {
        return result;
    }

    Object target() {
        return this.target;
    }
}

