/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.inference;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class InputTextReader
implements Releasable {
    private final BytesRefBlock textBlock;
    private final StringBuilder strBuilder = new StringBuilder();
    private BytesRef readBuffer = new BytesRef();

    public InputTextReader(BytesRefBlock textBlock) {
        this.textBlock = textBlock;
    }

    public String readText(int pos) {
        return this.readText(pos, Integer.MAX_VALUE);
    }

    public String readText(int pos, int limit) {
        if (this.textBlock.isNull(pos)) {
            return null;
        }
        this.strBuilder.setLength(0);
        int maxPos = Math.min(limit, this.textBlock.getValueCount(pos));
        for (int valueIndex = 0; valueIndex < maxPos; ++valueIndex) {
            this.readBuffer = this.textBlock.getBytesRef(this.textBlock.getFirstValueIndex(pos) + valueIndex, this.readBuffer);
            this.strBuilder.append(this.readBuffer.utf8ToString());
            if (valueIndex == maxPos - 1) continue;
            this.strBuilder.append("\n");
        }
        return this.strBuilder.toString();
    }

    public int estimatedSize() {
        return this.textBlock.getPositionCount();
    }

    public void close() {
        this.textBlock.allowPassingToDifferentDriver();
        Releasables.close((Releasable)this.textBlock);
    }
}

