/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvLast;

public final class MvLastBooleanEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(MvLastBooleanEvaluator.class);

    public MvLastBooleanEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
    }

    @Override
    public String name() {
        return "MvLast";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        BooleanBlock v = (BooleanBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BooleanBlock.Builder builder = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                boolean result = MvLast.process(v, first, end);
                builder.appendBoolean(result);
            }
            BooleanBlock booleanBlock = builder.build();
            return booleanBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        BooleanBlock v = (BooleanBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (BooleanVector.FixedBuilder builder = this.driverContext.blockFactory().newBooleanVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                boolean result = MvLast.process(v, first, end);
                builder.appendBoolean(result);
            }
            BooleanBlock booleanBlock = builder.build().asBlock();
            return booleanBlock;
        }
    }

    public long baseRamBytesUsed() {
        return BASE_RAM_BYTES_USED + this.field.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvLastBooleanEvaluator get(DriverContext context) {
            return new MvLastBooleanEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvLast[field=" + String.valueOf(this.field) + "]";
        }
    }
}

