/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.time.ZoneId;
import java.util.Locale;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DayName;

public final class DayNameMillisEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(DayNameMillisEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator val;
    private final ZoneId zoneId;
    private final Locale locale;
    private final DriverContext driverContext;
    private Warnings warnings;

    public DayNameMillisEvaluator(Source source, EvalOperator.ExpressionEvaluator val, ZoneId zoneId, Locale locale, DriverContext driverContext) {
        this.source = source;
        this.val = val;
        this.zoneId = zoneId;
        this.locale = locale;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock valBlock = (LongBlock)this.val.eval(page);){
            LongVector valVector = valBlock.asVector();
            if (valVector == null) {
                BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), valBlock);
                return bytesRefBlock;
            }
            BytesRefBlock bytesRefBlock = this.eval(page.getPositionCount(), valVector).asBlock();
            return bytesRefBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.val.baseRamBytesUsed();
    }

    public BytesRefBlock eval(int positionCount, LongBlock valBlock) {
        try (BytesRefBlock.Builder result = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (valBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valBlock.getValueCount(p) != 1) {
                    if (valBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                long val = valBlock.getLong(valBlock.getFirstValueIndex(p));
                result.appendBytesRef(DayName.processMillis(val, this.zoneId, this.locale));
            }
            BytesRefBlock bytesRefBlock = result.build();
            return bytesRefBlock;
        }
    }

    public BytesRefVector eval(int positionCount, LongVector valVector) {
        try (BytesRefVector.Builder result = this.driverContext.blockFactory().newBytesRefVectorBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                long val = valVector.getLong(p);
                result.appendBytesRef(DayName.processMillis(val, this.zoneId, this.locale));
            }
            BytesRefVector bytesRefVector = result.build();
            return bytesRefVector;
        }
    }

    public String toString() {
        return "DayNameMillisEvaluator[val=" + String.valueOf(this.val) + ", zoneId=" + String.valueOf(this.zoneId) + ", locale=" + String.valueOf(this.locale) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.val);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory val;
        private final ZoneId zoneId;
        private final Locale locale;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory val, ZoneId zoneId, Locale locale) {
            this.source = source;
            this.val = val;
            this.zoneId = zoneId;
            this.locale = locale;
        }

        public DayNameMillisEvaluator get(DriverContext context) {
            return new DayNameMillisEvaluator(this.source, this.val.get(context), this.zoneId, this.locale, context);
        }

        public String toString() {
            return "DayNameMillisEvaluator[val=" + String.valueOf(this.val) + ", zoneId=" + String.valueOf(this.zoneId) + ", locale=" + String.valueOf(this.locale) + "]";
        }
    }
}

