/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Percentile;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMedian;

public class Median
extends AggregateFunction
implements SurrogateExpression {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Median", Median::new);

    @FunctionInfo(returnType={"double"}, description="The value that is greater than half of all values and less than half of all values, also known as the 50% <<esql-percentile>>.", note="Like <<esql-percentile>>, `MEDIAN` is <<esql-percentile-approximate,usually approximate>>.", appendix="::::{warning}\n`MEDIAN` is also {wikipedia}/Nondeterministic_algorithm[non-deterministic].\nThis means you can get slightly different results using the same data.\n::::", type=FunctionType.AGGREGATE, examples={@Example(file="stats_percentile", tag="median"), @Example(description="The expression can use inline functions. For example, to calculate the median of the maximum values of a multivalued column, first use `MV_MAX` to get the maximum value per row, and use the result with the `MEDIAN` function", file="stats_percentile", tag="docsStatsMedianNestedExpression")})
    public Median(Source source, @Param(name="number", type={"double", "integer", "long"}, description="Expression that outputs values to calculate the median of.") Expression field) {
        this(source, field, (Expression)Literal.TRUE);
    }

    public Median(Source source, Expression field, Expression filter) {
        super(source, field, filter, Collections.emptyList());
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> dt.isNumeric() && dt != DataType.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"numeric except unsigned_long or counter types"});
    }

    private Median(StreamInput in) throws IOException {
        super(in);
    }

    public String getWriteableName() {
        return Median.ENTRY.name;
    }

    public DataType dataType() {
        return DataType.DOUBLE;
    }

    protected NodeInfo<Median> info() {
        return NodeInfo.create((Node)this, Median::new, (Object)this.field(), (Object)this.filter());
    }

    public Median replaceChildren(List<Expression> newChildren) {
        return new Median(this.source(), newChildren.get(0), newChildren.get(1));
    }

    @Override
    public AggregateFunction withFilter(Expression filter) {
        return new Median(this.source(), this.field(), filter);
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        Expression field = this.field();
        return field.foldable() ? new MvMedian(s, (Expression)new ToDouble(s, field)) : new Percentile(this.source(), this.field(), this.filter(), (Expression)new Literal(this.source(), (Object)50, DataType.INTEGER));
    }
}

