/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

final class InstanceType
implements ToXContentObject {
    final String provider;
    final String region;
    final String name;

    InstanceType(String provider, String region, String name) {
        this.provider = provider != null ? provider : "";
        this.region = region != null ? region : "";
        this.name = name != null ? name : "";
    }

    public static InstanceType fromHostSource(Map<String, Object> source) {
        String provider = (String)source.get("cloud.provider");
        if (provider != null) {
            String region = (String)source.get("cloud.region");
            String instanceType = (String)source.get("host.type");
            return new InstanceType(provider, region, instanceType);
        }
        InstanceType instanceType = InstanceType.fromObsoleteHostSource(source);
        if (instanceType != null) {
            return instanceType;
        }
        String region = null;
        List<String> tags = InstanceType.listOf(source.get("profiling.host.tags"));
        for (String tag : tags) {
            String[] kv = tag.toLowerCase(Locale.ROOT).split(":", 2);
            if (kv.length != 2) continue;
            if ("cloud_provider".equals(kv[0])) {
                provider = kv[1];
            }
            if (!"cloud_region".equals(kv[0])) continue;
            region = kv[1];
        }
        return new InstanceType(provider, region, null);
    }

    private static InstanceType fromObsoleteHostSource(Map<String, Object> source) {
        Object region = (String)source.get("ec2.placement.region");
        if (region != null) {
            String instanceType = (String)source.get("ec2.instance_type");
            return new InstanceType("aws", (String)region, instanceType);
        }
        String zone = (String)source.get("gce.instance.zone");
        if (zone != null) {
            region = zone.substring(zone.lastIndexOf(47) + 1);
            String[] tokens = ((String)region).split("-", 3);
            if (tokens.length > 2) {
                region = tokens[0] + "-" + tokens[1];
            }
            return new InstanceType("gcp", (String)region, null);
        }
        region = (String)source.get("azure.compute.location");
        if (region != null) {
            String instanceType = (String)source.get("azure.compute.vmsize");
            return new InstanceType("azure", (String)region, instanceType);
        }
        return null;
    }

    private static <T> List<T> listOf(Object o) {
        if (o instanceof List) {
            return (List)o;
        }
        if (o != null) {
            return List.of(o);
        }
        return Collections.emptyList();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("provider", this.provider);
        builder.field("region", this.region);
        builder.field("instance_type", this.name);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceType that = (InstanceType)o;
        return this.provider.equals(that.provider) && this.region.equals(that.region) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.provider, this.region, this.name);
    }

    public String toString() {
        return "provider '" + this.name + "' in region '" + this.region + "'";
    }
}

