/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.RunOnce;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.transport.ProfileConfigurations;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.core.ssl.SslProfile;
import org.elasticsearch.xpack.security.authz.AuthorizationUtils;
import org.elasticsearch.xpack.security.authz.PreAuthorizationUtils;
import org.elasticsearch.xpack.security.transport.RemoteClusterTransportInterceptor;
import org.elasticsearch.xpack.security.transport.ServerTransportFilter;

public class SecurityServerTransportInterceptor
implements TransportInterceptor {
    private static final Logger logger = LogManager.getLogger(SecurityServerTransportInterceptor.class);
    private final RemoteClusterTransportInterceptor remoteClusterTransportInterceptor;
    private final Map<String, ServerTransportFilter> profileFilters;
    private final ThreadPool threadPool;
    private final SecurityContext securityContext;

    public SecurityServerTransportInterceptor(Settings settings, ThreadPool threadPool, SSLService sslService, SecurityContext securityContext, DestructiveOperations destructiveOperations, RemoteClusterTransportInterceptor remoteClusterTransportInterceptor) {
        this.remoteClusterTransportInterceptor = remoteClusterTransportInterceptor;
        this.securityContext = securityContext;
        this.threadPool = threadPool;
        Map<String, SslProfile> profileConfigurations = ProfileConfigurations.get(settings, sslService, false);
        this.profileFilters = this.remoteClusterTransportInterceptor.getProfileTransportFilters(profileConfigurations, destructiveOperations);
    }

    public TransportInterceptor.AsyncSender interceptSender(TransportInterceptor.AsyncSender sender) {
        return this.interceptForAllRequests(this.remoteClusterTransportInterceptor.interceptSender(sender));
    }

    private TransportInterceptor.AsyncSender interceptForAllRequests(final TransportInterceptor.AsyncSender sender) {
        return new TransportInterceptor.AsyncSender(){

            public <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                assert (!SecurityServerTransportInterceptor.this.remoteClusterTransportInterceptor.hasRemoteClusterAccessHeadersInContext(SecurityServerTransportInterceptor.this.securityContext)) : "remote cluster access headers should not be in security context";
                boolean isRemoteClusterConnection = SecurityServerTransportInterceptor.this.remoteClusterTransportInterceptor.isRemoteClusterConnection(connection);
                if (PreAuthorizationUtils.shouldRemoveParentAuthorizationFromThreadContext(action, SecurityServerTransportInterceptor.this.securityContext, isRemoteClusterConnection)) {
                    SecurityServerTransportInterceptor.this.securityContext.executeAfterRemovingParentAuthorization(original -> SecurityServerTransportInterceptor.this.sendRequestInner(sender, connection, action, request, options, new TransportService.ContextRestoreResponseHandler(SecurityServerTransportInterceptor.this.threadPool.getThreadContext().wrapRestorable(original), handler)));
                } else {
                    SecurityServerTransportInterceptor.this.sendRequestInner(sender, connection, action, request, options, handler);
                }
            }
        };
    }

    public <T extends TransportResponse> void sendRequestInner(TransportInterceptor.AsyncSender sender, Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        TransportVersion minVersion = TransportVersion.min((TransportVersion)connection.getTransportVersion(), (TransportVersion)TransportVersion.current());
        if (AuthorizationUtils.shouldReplaceUserWithSystem(this.threadPool.getThreadContext(), action)) {
            this.securityContext.executeAsSystemUser(minVersion, original -> this.sendWithUser(connection, action, request, options, (TransportResponseHandler)new TransportService.ContextRestoreResponseHandler(this.threadPool.getThreadContext().wrapRestorable(original), handler), sender));
        } else if (AuthorizationUtils.shouldSetUserBasedOnActionOrigin(this.threadPool.getThreadContext())) {
            AuthorizationUtils.switchUserBasedOnActionOriginAndExecute(this.threadPool.getThreadContext(), this.securityContext, minVersion, original -> this.sendWithUser(connection, action, request, options, (TransportResponseHandler)new TransportService.ContextRestoreResponseHandler(this.threadPool.getThreadContext().wrapRestorable(original), handler), sender));
        } else if (this.securityContext.getAuthentication() != null && !this.securityContext.getAuthentication().getEffectiveSubject().getTransportVersion().equals((Object)minVersion)) {
            this.securityContext.executeAfterRewritingAuthentication(original -> this.sendWithUser(connection, action, request, options, (TransportResponseHandler)new TransportService.ContextRestoreResponseHandler(this.threadPool.getThreadContext().wrapRestorable(original), handler), sender), minVersion);
        } else {
            this.sendWithUser(connection, action, request, options, handler, sender);
        }
    }

    Map<String, ServerTransportFilter> getProfileFilters() {
        return this.profileFilters;
    }

    private <T extends TransportResponse> void sendWithUser(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler, TransportInterceptor.AsyncSender sender) {
        if (this.securityContext.getAuthentication() == null) {
            this.assertNoAuthentication(action);
            throw new IllegalStateException("there should always be a user when sending a message for action [" + action + "]");
        }
        assert (this.securityContext.getParentAuthorization() == null || !this.remoteClusterTransportInterceptor.isRemoteClusterConnection(connection)) : "parent authorization header should not be set for remote cluster requests";
        try {
            sender.sendRequest(connection, action, request, options, handler);
        }
        catch (Exception e) {
            handler.handleException((TransportException)new SendRequestTransportException(connection.getNode(), action, (Throwable)e));
        }
    }

    void assertNoAuthentication(String action) {
        assert (false) : "there should always be a user when sending a message for action [" + action + "]";
    }

    public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, Executor executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
        return new ProfileSecuredRequestHandler<T>(logger, action, forceExecution, executor, actualHandler, this.profileFilters, this.threadPool);
    }

    public static class ProfileSecuredRequestHandler<T extends TransportRequest>
    implements TransportRequestHandler<T> {
        private final String action;
        private final TransportRequestHandler<T> handler;
        private final Map<String, ServerTransportFilter> profileFilters;
        private final ThreadContext threadContext;
        private final Executor executor;
        private final ThreadPool threadPool;
        private final boolean forceExecution;
        private final Logger logger;

        ProfileSecuredRequestHandler(Logger logger, String action, boolean forceExecution, Executor executor, TransportRequestHandler<T> handler, Map<String, ServerTransportFilter> profileFilters, ThreadPool threadPool) {
            this.logger = logger;
            this.action = action;
            this.executor = executor;
            this.handler = handler;
            this.profileFilters = profileFilters;
            this.threadContext = threadPool.getThreadContext();
            this.threadPool = threadPool;
            this.forceExecution = forceExecution;
        }

        AbstractRunnable getReceiveRunnable(T request, final TransportChannel channel, Task task) {
            RunOnce releaseRequest = new RunOnce(() -> request.decRef());
            request.mustIncRef();
            return new AbstractRunnable((TransportRequest)request, task, (Runnable)releaseRequest){
                final /* synthetic */ TransportRequest val$request;
                final /* synthetic */ Task val$task;
                final /* synthetic */ Runnable val$releaseRequest;
                {
                    this.val$request = transportRequest;
                    this.val$task = task;
                    this.val$releaseRequest = runnable;
                }

                public boolean isForceExecution() {
                    return forceExecution;
                }

                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        e1.addSuppressed(e);
                        logger.warn("failed to send exception response for action [" + action + "]", (Throwable)e1);
                    }
                }

                protected void doRun() throws Exception {
                    handler.messageReceived(this.val$request, channel, this.val$task);
                }

                public void onAfter() {
                    this.val$releaseRequest.run();
                }
            };
        }

        public String toString() {
            return "ProfileSecuredRequestHandler{action='" + this.action + "', forceExecution=" + this.forceExecution + "}";
        }

        public void messageReceived(T request, TransportChannel channel, Task task) {
            try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContextPreservingResponseHeaders();){
                AbstractFilterListener filterListener;
                String profile = channel.getProfileName();
                ServerTransportFilter filter = this.getServerTransportFilter(profile);
                assert (filter != null);
                assert (request != null);
                this.logger.trace(() -> Strings.format((String)"Applying transport filter [%s] for transport profile [%s] on request [%s]", (Object[])new Object[]{filter.getClass(), profile, request.getClass()}));
                AbstractRunnable receiveMessage = this.getReceiveRunnable(request, channel, task);
                if (this.executor == EsExecutors.DIRECT_EXECUTOR_SERVICE) {
                    filterListener = new AbstractFilterListener(this, receiveMessage){

                        public void onResponse(Void unused) {
                            this.receiveMessage.run();
                        }
                    };
                } else {
                    final Thread executingThread = Thread.currentThread();
                    filterListener = new AbstractFilterListener(receiveMessage){

                        public void onResponse(Void unused) {
                            if (executingThread == Thread.currentThread()) {
                                this.receiveMessage.run();
                            } else {
                                try {
                                    executor.execute((Runnable)this.receiveMessage);
                                }
                                catch (Exception e) {
                                    this.onFailure(e);
                                }
                            }
                        }
                    };
                }
                filter.inbound(this.action, (TransportRequest)request, channel, filterListener);
            }
        }

        private ServerTransportFilter getServerTransportFilter(String profile) {
            ServerTransportFilter filter = this.profileFilters.get(profile);
            if (filter != null) {
                return filter;
            }
            if (".direct".equals(profile)) {
                return this.profileFilters.get("default");
            }
            String msg = "transport profile [" + profile + "] is not associated with a transport filter";
            throw new IllegalStateException(msg);
        }
    }

    private static abstract class AbstractFilterListener
    implements ActionListener<Void> {
        protected final AbstractRunnable receiveMessage;

        protected AbstractFilterListener(AbstractRunnable receiveMessage) {
            this.receiveMessage = receiveMessage;
        }

        public void onFailure(Exception e) {
            try {
                this.receiveMessage.onFailure(e);
            }
            finally {
                this.receiveMessage.onAfter();
            }
        }
    }
}

