/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest;

import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestContentAggregator;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestInterceptor;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.xpack.core.security.authc.support.SecondaryAuthentication;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.authc.support.SecondaryAuthenticator;
import org.elasticsearch.xpack.security.authz.restriction.WorkflowService;
import org.elasticsearch.xpack.security.operator.OperatorPrivileges;

public class SecurityRestFilter
implements RestInterceptor {
    private static final Logger logger = LogManager.getLogger(SecurityRestFilter.class);
    private final SecondaryAuthenticator secondaryAuthenticator;
    private final AuditTrailService auditTrailService;
    private final boolean enabled;
    private final ThreadContext threadContext;
    private final OperatorPrivileges.OperatorPrivilegesService operatorPrivilegesService;

    public SecurityRestFilter(boolean enabled, ThreadContext threadContext, SecondaryAuthenticator secondaryAuthenticator, AuditTrailService auditTrailService, OperatorPrivileges.OperatorPrivilegesService operatorPrivilegesService) {
        this.enabled = enabled;
        this.threadContext = threadContext;
        this.secondaryAuthenticator = secondaryAuthenticator;
        this.auditTrailService = auditTrailService;
        this.operatorPrivilegesService = operatorPrivilegesService == null ? OperatorPrivileges.NOOP_OPERATOR_PRIVILEGES_SERVICE : operatorPrivilegesService;
    }

    public void intercept(RestRequest request, RestChannel channel, RestHandler targetHandler, ActionListener<Boolean> listener) throws Exception {
        if (request.method() == RestRequest.Method.OPTIONS) {
            this.handleException(request, (Exception)((Object)new ElasticsearchSecurityException("Cannot dispatch OPTIONS request, as they are not authenticated", new Object[0])), listener);
            return;
        }
        if (!this.enabled) {
            listener.onResponse((Object)Boolean.TRUE);
            return;
        }
        Consumer<RestRequest> aggregationCallback = aggregatedRestRequest -> {
            RestRequest wrappedRequest = this.maybeWrapRestRequest((RestRequest)aggregatedRestRequest, targetHandler);
            this.auditTrailService.get().authenticationSuccess(wrappedRequest);
            this.secondaryAuthenticator.authenticateAndAttachToContext(wrappedRequest, (ActionListener<SecondaryAuthentication>)ActionListener.wrap(secondaryAuthentication -> {
                if (secondaryAuthentication != null) {
                    logger.trace("Found secondary authentication {} in REST request [{}]", secondaryAuthentication, (Object)aggregatedRestRequest.uri());
                }
                WorkflowService.resolveWorkflowAndStoreInThreadContext(targetHandler, this.threadContext);
                this.doHandleRequest((RestRequest)aggregatedRestRequest, channel, targetHandler, listener);
            }, e -> this.handleException((RestRequest)aggregatedRestRequest, (Exception)e, listener)));
        };
        if (request.isStreamedContent() && this.auditTrailService.includeRequestBody()) {
            RestContentAggregator.aggregate((RestRequest)request, aggregationCallback::accept);
        } else {
            aggregationCallback.accept(request);
        }
    }

    private void doHandleRequest(RestRequest request, RestChannel channel, RestHandler targetHandler, ActionListener<Boolean> listener) {
        this.threadContext.sanitizeHeaders();
        if (this.operatorPrivilegesService.checkRest(targetHandler, request, channel, this.threadContext)) {
            listener.onResponse((Object)Boolean.TRUE);
        } else {
            listener.onResponse((Object)Boolean.FALSE);
        }
    }

    protected void handleException(RestRequest request, Exception e, ActionListener<?> listener) {
        logger.debug(() -> Strings.format((String)"failed for REST request [%s]", (Object[])new Object[]{request.uri()}), (Throwable)e);
        this.threadContext.sanitizeHeaders();
        listener.onFailure(e);
    }

    OperatorPrivileges.OperatorPrivilegesService getOperatorPrivilegesService() {
        return this.operatorPrivilegesService;
    }

    private RestRequest maybeWrapRestRequest(RestRequest restRequest, RestHandler targetHandler) {
        if (targetHandler instanceof RestRequestFilter) {
            RestRequestFilter rrf = (RestRequestFilter)targetHandler;
            return rrf.getFilteredRequest(restRequest);
        }
        return restRequest;
    }
}

