/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.lucene50;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.backward_codecs.lucene50.Lucene50PostingsReader;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.PostingsReaderBase;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.xpack.lucene.bwc.codecs.lucene40.blocktree.Lucene40BlockTreeTermsReader;

public class BWCLucene50PostingsFormat
extends PostingsFormat {
    public static final String DOC_EXTENSION = "doc";
    public static final String POS_EXTENSION = "pos";
    public static final String PAY_EXTENSION = "pay";
    static final int MAX_SKIP_LEVELS = 10;
    static final String TERMS_CODEC = "Lucene50PostingsWriterTerms";
    static final String DOC_CODEC = "Lucene50PostingsWriterDoc";
    static final String POS_CODEC = "Lucene50PostingsWriterPos";
    static final String PAY_CODEC = "Lucene50PostingsWriterPay";
    static final int VERSION_START = 0;
    static final int VERSION_IMPACT_SKIP_DATA = 1;
    static final int VERSION_CURRENT = 1;
    public static final int BLOCK_SIZE = 128;

    public BWCLucene50PostingsFormat() {
        super("Lucene50");
    }

    public BWCLucene50PostingsFormat(String name) {
        super(name);
    }

    public String toString() {
        return this.getName() + "(blocksize=128)";
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        throw new UnsupportedOperationException("Old formats can't be used for writing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        Lucene50PostingsReader postingsReader = new Lucene50PostingsReader(state);
        boolean success = false;
        try {
            Lucene40BlockTreeTermsReader ret = new Lucene40BlockTreeTermsReader((PostingsReaderBase)postingsReader, state);
            success = true;
            Lucene40BlockTreeTermsReader lucene40BlockTreeTermsReader = ret;
            return lucene40BlockTreeTermsReader;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException((Closeable)postingsReader);
            }
        }
    }
}

