/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.archive.ArchiveFeatureSetUsage;
import org.elasticsearch.xpack.lucene.bwc.OldLuceneVersions;

public class ArchiveUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final XPackLicenseState licenseState;
    private final ProjectResolver projectResolver;

    @Inject
    public ArchiveUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, XPackLicenseState licenseState, ProjectResolver projectResolver) {
        super(XPackUsageFeatureAction.ARCHIVE.name(), transportService, clusterService, threadPool, actionFilters);
        this.licenseState = licenseState;
        this.projectResolver = projectResolver;
    }

    protected void localClusterStateOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        int numArchiveIndices = 0;
        for (IndexMetadata indexMetadata : this.projectResolver.getProjectMetadata(state)) {
            if (!indexMetadata.getCreationVersion().isLegacyIndexVersion()) continue;
            ++numArchiveIndices;
        }
        listener.onResponse((Object)new XPackUsageFeatureResponse((XPackFeatureUsage)new ArchiveFeatureSetUsage(OldLuceneVersions.ARCHIVE_FEATURE.checkWithoutTracking(this.licenseState), numArchiveIndices)));
    }
}

