/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.rest;

import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.enrich.action.EnrichStatsAction;

@ServerlessScope(value=Scope.INTERNAL)
public class RestEnrichStatsAction
extends BaseRestHandler {
    private static final Set<String> SUPPORTED_CAPABILITIES = Set.of("size-in-bytes");

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_enrich/_stats"));
    }

    public String getName() {
        return "enrich_stats";
    }

    public Set<String> supportedCapabilities() {
        return SUPPORTED_CAPABILITIES;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        EnrichStatsAction.Request request = new EnrichStatsAction.Request(RestUtils.getMasterNodeTimeout((RestRequest)restRequest));
        return channel -> new RestCancellableNodeClient(client, restRequest.getHttpChannel()).execute((ActionType)EnrichStatsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

