/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.action;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeProjectAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.PipelineConfiguration;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.core.enrich.action.DeleteEnrichPolicyAction;
import org.elasticsearch.xpack.enrich.AbstractEnrichProcessor;
import org.elasticsearch.xpack.enrich.EnrichPolicyLocks;
import org.elasticsearch.xpack.enrich.EnrichStore;

public class TransportDeleteEnrichPolicyAction
extends AcknowledgedTransportMasterNodeProjectAction<DeleteEnrichPolicyAction.Request> {
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final EnrichPolicyLocks enrichPolicyLocks;
    private final IngestService ingestService;
    private final Client client;
    private static final IndicesOptions LENIENT_OPTIONS = IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)true, (boolean)true);

    @Inject
    public TransportDeleteEnrichPolicyAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver, Client client, EnrichPolicyLocks enrichPolicyLocks, IngestService ingestService) {
        super("cluster:admin/xpack/enrich/delete", transportService, clusterService, threadPool, actionFilters, DeleteEnrichPolicyAction.Request::new, projectResolver, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.client = client;
        this.enrichPolicyLocks = enrichPolicyLocks;
        this.ingestService = ingestService;
    }

    protected void masterOperation(Task task, DeleteEnrichPolicyAction.Request request, ProjectState state, ActionListener<AcknowledgedResponse> listener) {
        String policyName = request.getName();
        EnrichPolicy policy = EnrichStore.getPolicy(policyName, state.metadata());
        if (policy == null) {
            throw new ResourceNotFoundException("policy [{}] not found", new Object[]{policyName});
        }
        EnrichPolicyLocks.EnrichPolicyLock policyLock = this.enrichPolicyLocks.lockPolicy(policyName);
        try {
            List pipelines = IngestService.getPipelines((ProjectMetadata)state.metadata(), (String[])new String[0]);
            ArrayList<String> pipelinesWithProcessors = new ArrayList<String>();
            for (PipelineConfiguration pipelineConfiguration : pipelines) {
                List enrichProcessors = this.ingestService.getProcessorsInPipeline(state.projectId(), pipelineConfiguration.getId(), AbstractEnrichProcessor.class);
                for (AbstractEnrichProcessor processor : enrichProcessors) {
                    if (!processor.getPolicyName().equals(policyName)) continue;
                    pipelinesWithProcessors.add(pipelineConfiguration.getId());
                }
            }
            if (!pipelinesWithProcessors.isEmpty()) {
                throw new ElasticsearchStatusException("Could not delete policy [{}] because a pipeline is referencing it {}", RestStatus.CONFLICT, new Object[]{policyName, pipelinesWithProcessors});
            }
        }
        catch (Exception e) {
            policyLock.close();
            listener.onFailure(e);
            return;
        }
        try {
            GetIndexRequest indices = new GetIndexRequest(request.masterNodeTimeout()).indices(new String[]{EnrichPolicy.getBaseName((String)policyName) + "-*"}).indicesOptions(IndicesOptions.lenientExpand());
            String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNamesWithSystemIndexAccess(state.metadata(), (IndicesRequest)indices);
            concreteIndices = (String[])Stream.of(concreteIndices).filter(i -> EnrichPolicy.isPolicyForIndex((String)policyName, (String)i)).toArray(String[]::new);
            this.deleteIndicesAndPolicy(state.projectId(), concreteIndices, policyName, (ActionListener<AcknowledgedResponse>)ActionListener.runBefore(listener, policyLock::close));
        }
        catch (Exception e) {
            policyLock.close();
            listener.onFailure(e);
        }
    }

    private void deleteIndicesAndPolicy(ProjectId projectId, String[] indices, String name, ActionListener<AcknowledgedResponse> listener) {
        if (indices.length == 0) {
            this.deletePolicy(projectId, name, listener);
            return;
        }
        DeleteIndexRequest deleteRequest = new DeleteIndexRequest().indices(indices).indicesOptions(LENIENT_OPTIONS);
        new OriginSettingClient(this.client, "enrich").admin().indices().delete(deleteRequest, listener.delegateFailureAndWrap((delegate, response) -> {
            if (!response.isAcknowledged()) {
                delegate.onFailure((Exception)new ElasticsearchStatusException("Could not fetch indices to delete during policy delete of [{}]", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{name}));
            } else {
                this.deletePolicy(projectId, name, (ActionListener<AcknowledgedResponse>)delegate);
            }
        }));
    }

    private void deletePolicy(ProjectId projectId, String name, ActionListener<AcknowledgedResponse> listener) {
        EnrichStore.deletePolicy(projectId, name, this.clusterService, e -> {
            if (e == null) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            } else {
                listener.onFailure(e);
            }
        });
    }

    protected ClusterBlockException checkBlock(DeleteEnrichPolicyAction.Request request, ProjectState state) {
        return state.blocks().globalBlockedException(state.projectId(), ClusterBlockLevel.METADATA_WRITE);
    }
}

