/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchbusinessrules.retriever;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.RankDocsQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.retriever.CompoundRetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilderWrapper;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.searchbusinessrules.PinnedQueryBuilder;
import org.elasticsearch.xpack.searchbusinessrules.SpecifiedDocument;
import org.elasticsearch.xpack.searchbusinessrules.retriever.PinnedRankDoc;

public final class PinnedRetrieverBuilder
extends CompoundRetrieverBuilder<PinnedRetrieverBuilder> {
    public static final String NAME = "pinned";
    public static final ParseField IDS_FIELD = new ParseField("ids", new String[0]);
    public static final ParseField DOCS_FIELD = new ParseField("docs", new String[0]);
    public static final ParseField RETRIEVER_FIELD = new ParseField("retriever", new String[0]);
    public static final NodeFeature PINNED_RETRIEVER_FEATURE = new NodeFeature("pinned_retriever_supported");
    public static final ConstructingObjectParser<PinnedRetrieverBuilder, RetrieverParserContext> PARSER = new ConstructingObjectParser("pinned", args -> {
        List ids = (List)args[0];
        List docs = (List)args[1];
        RetrieverBuilder retrieverBuilder = (RetrieverBuilder)args[2];
        int rankWindowSize = args[3] == null ? 10 : (Integer)args[3];
        return new PinnedRetrieverBuilder(ids, docs, retrieverBuilder, rankWindowSize);
    });
    private final List<String> ids;
    private final List<SpecifiedDocument> docs;

    public static PinnedRetrieverBuilder fromXContent(XContentParser parser, RetrieverParserContext context) throws IOException {
        try {
            return (PinnedRetrieverBuilder)((Object)PARSER.apply(parser, (Object)context));
        }
        catch (Exception e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    private void validateIdsAndDocs(List<String> ids, List<SpecifiedDocument> docs) {
        boolean validDocs;
        if (ids != null && docs != null) {
            throw new IllegalArgumentException("Both 'ids' and 'docs' cannot be specified at the same time");
        }
        boolean validIds = ids != null && !ids.isEmpty();
        boolean bl = validDocs = docs != null && !docs.isEmpty();
        if (!validIds && !validDocs) {
            throw new IllegalArgumentException("Either 'ids' or 'docs' must be provided and non-empty for pinned retriever");
        }
    }

    private void validateSort(SearchSourceBuilder source) {
        List sorts = source.sorts();
        if (sorts == null || sorts.isEmpty()) {
            return;
        }
        SortBuilder sort = (SortBuilder)sorts.get(0);
        if (!(sort instanceof ScoreSortBuilder)) {
            throw new IllegalArgumentException("[pinned] retriever only supports sorting by score, invalid sort criterion: " + sort.toString());
        }
    }

    public PinnedRetrieverBuilder(List<String> ids, List<SpecifiedDocument> docs, RetrieverBuilder retrieverBuilder, int rankWindowSize) {
        super(new ArrayList(), rankWindowSize);
        this.validateIdsAndDocs(ids, docs);
        this.ids = ids;
        this.docs = docs;
        this.addChild((RetrieverBuilder)new PinnedRetrieverBuilderWrapper(retrieverBuilder));
    }

    public PinnedRetrieverBuilder(List<String> ids, List<SpecifiedDocument> docs, List<CompoundRetrieverBuilder.RetrieverSource> retrieverSource, int rankWindowSize, String retrieverName, List<QueryBuilder> preFilterQueryBuilders) {
        super(retrieverSource, rankWindowSize);
        this.validateIdsAndDocs(ids, docs);
        this.ids = ids;
        this.docs = docs;
        this.retrieverName = retrieverName;
        this.preFilterQueryBuilders = preFilterQueryBuilders;
    }

    public String getName() {
        return NAME;
    }

    private QueryBuilder createPinnedQuery(QueryBuilder baseQuery) {
        Objects.requireNonNull(baseQuery, "pinned retriever requires retriever with associated query");
        if (this.docs != null && !this.docs.isEmpty()) {
            return new PinnedQueryBuilder(baseQuery, this.docs.toArray(new SpecifiedDocument[0]));
        }
        return new PinnedQueryBuilder(baseQuery, this.ids.toArray(new String[0]));
    }

    protected SearchSourceBuilder finalizeSourceBuilder(SearchSourceBuilder source) {
        this.validateSort(source);
        QueryBuilder underlyingQuery = source.query();
        if (underlyingQuery == null) {
            throw new IllegalArgumentException("pinned retriever requires retriever with associated query");
        }
        source.query(this.createPinnedQuery(underlyingQuery));
        return source;
    }

    public void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.ids != null) {
            builder.array(IDS_FIELD.getPreferredName(), this.ids.toArray());
        }
        if (this.docs != null) {
            builder.startArray(DOCS_FIELD.getPreferredName());
            for (SpecifiedDocument doc : this.docs) {
                builder.value((ToXContent)doc);
            }
            builder.endArray();
        }
        builder.field(RETRIEVER_FIELD.getPreferredName(), (ToXContent)((CompoundRetrieverBuilder.RetrieverSource)this.innerRetrievers.getFirst()).retriever());
        builder.field(RANK_WINDOW_SIZE_FIELD.getPreferredName(), this.rankWindowSize);
    }

    protected PinnedRetrieverBuilder clone(List<CompoundRetrieverBuilder.RetrieverSource> newChildRetrievers, List<QueryBuilder> newPreFilterQueryBuilders) {
        return new PinnedRetrieverBuilder(this.ids, this.docs, newChildRetrievers, this.rankWindowSize, this.retrieverName, newPreFilterQueryBuilders);
    }

    protected RankDoc[] combineInnerRetrieverResults(List<ScoreDoc[]> rankResults, boolean explain) {
        assert (rankResults.size() == 1);
        ScoreDoc[] scoreDocs = rankResults.getFirst();
        RankDoc[] rankDocs = new RankDoc[scoreDocs.length];
        for (int i = 0; i < scoreDocs.length; ++i) {
            ScoreDoc scoreDoc = scoreDocs[i];
            if (explain) {
                boolean isPinned;
                boolean bl = isPinned = scoreDoc.score > PinnedQueryBuilder.MAX_ORGANIC_SCORE;
                if (isPinned) {
                    String pinnedBy = this.ids != null && !this.ids.isEmpty() ? "ids" : "docs";
                    rankDocs[i] = new PinnedRankDoc(scoreDoc.doc, scoreDoc.score, scoreDoc.shardIndex, true);
                } else {
                    rankDocs[i] = new RankDoc(scoreDoc.doc, scoreDoc.score, scoreDoc.shardIndex);
                }
            } else {
                rankDocs[i] = new RankDoc(scoreDoc.doc, scoreDoc.score, scoreDoc.shardIndex);
            }
            rankDocs[i].rank = i + 1;
        }
        return rankDocs;
    }

    public boolean doEquals(Object o) {
        PinnedRetrieverBuilder that = (PinnedRetrieverBuilder)((Object)o);
        return super.doEquals(o) && Objects.equals(this.ids, that.ids) && Objects.equals(this.docs, that.docs);
    }

    public int doHashCode() {
        return Objects.hash(super.doHashCode(), this.ids, this.docs);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), IDS_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> (SpecifiedDocument)SpecifiedDocument.PARSER.apply(p, null), DOCS_FIELD);
        PARSER.declareNamedObject(ConstructingObjectParser.constructorArg(), (p, c, n) -> {
            RetrieverBuilder innerRetriever = (RetrieverBuilder)p.namedObject(RetrieverBuilder.class, n, c);
            c.trackRetrieverUsage(innerRetriever);
            return innerRetriever;
        }, RETRIEVER_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RANK_WINDOW_SIZE_FIELD);
        RetrieverBuilder.declareBaseParserFields(PARSER);
    }

    class PinnedRetrieverBuilderWrapper
    extends RetrieverBuilderWrapper<PinnedRetrieverBuilderWrapper> {
        protected PinnedRetrieverBuilderWrapper(RetrieverBuilder in) {
            super(in);
        }

        protected PinnedRetrieverBuilderWrapper clone(RetrieverBuilder in) {
            return new PinnedRetrieverBuilderWrapper(in);
        }

        public QueryBuilder topDocsQuery() {
            return PinnedRetrieverBuilder.this.createPinnedQuery(this.in.topDocsQuery());
        }

        public QueryBuilder explainQuery() {
            RankDoc[] currentRankDocs = this.in.getRankDocs();
            if (currentRankDocs == null) {
                return this.in.explainQuery();
            }
            return new RankDocsQueryBuilder(currentRankDocs, new QueryBuilder[]{this.in.explainQuery()}, true);
        }
    }
}

