/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.retry;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.inference.external.http.HttpResult;

public class ErrorResponse {
    public static final ErrorResponse UNDEFINED_ERROR = new ErrorResponse(false);
    private final String errorMessage;
    private final boolean errorStructureFound;

    public ErrorResponse(String errorMessage) {
        this.errorMessage = Objects.requireNonNull(errorMessage);
        this.errorStructureFound = true;
    }

    protected ErrorResponse(boolean errorStructureFound) {
        this.errorMessage = "";
        this.errorStructureFound = errorStructureFound;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean errorStructureFound() {
        return this.errorStructureFound;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorResponse that = (ErrorResponse)o;
        return this.errorStructureFound == that.errorStructureFound && Objects.equals(this.errorMessage, that.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.errorMessage, this.errorStructureFound);
    }

    public static ErrorResponse fromResponse(HttpResult response) {
        try {
            String errorMessage = new String(response.body(), StandardCharsets.UTF_8);
            return new ErrorResponse(errorMessage);
        }
        catch (Exception exception) {
            return UNDEFINED_ERROR;
        }
    }

    public static ErrorResponse fromString(String response) {
        if (!Strings.isNullOrBlank((String)response)) {
            return new ErrorResponse(response);
        }
        return UNDEFINED_ERROR;
    }
}

