/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patterntext;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOFunction;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.common.CheckedIntFunction;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockStoredFieldsReader;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.extras.SourceConfirmedTextQuery;
import org.elasticsearch.index.mapper.extras.SourceIntervalsSource;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.xpack.logsdb.patterntext.DelimiterAnalyzer;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextBlockLoader;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextCompositeValues;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextFieldMapper;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextIndexFieldData;

public class PatternTextFieldType
extends StringFieldType {
    private static final String STORED_SUFFIX = ".stored";
    private static final String TEMPLATE_SUFFIX = ".template";
    private static final String TEMPLATE_ID_SUFFIX = ".template_id";
    private static final String ARGS_SUFFIX = ".args";
    private static final String ARGS_INFO_SUFFIX = ".args_info";
    public static final String CONTENT_TYPE = "pattern_text";
    private final Analyzer indexAnalyzer;
    private final TextFieldMapper.TextFieldType textFieldType;
    private final boolean hasPositions;
    private final boolean disableTemplating;

    PatternTextFieldType(String name, TextSearchInfo tsi, Analyzer indexAnalyzer, boolean isSyntheticSource, boolean disableTemplating, Map<String, String> meta) {
        super(name, true, false, false, tsi, meta);
        this.indexAnalyzer = Objects.requireNonNull(indexAnalyzer);
        this.textFieldType = new TextFieldMapper.TextFieldType(name, isSyntheticSource);
        this.hasPositions = tsi.hasPositions();
        this.disableTemplating = disableTemplating;
    }

    PatternTextFieldType(String name, boolean hasPositions, boolean syntheticSource) {
        this(name, new TextSearchInfo(hasPositions ? PatternTextFieldMapper.Defaults.FIELD_TYPE_POSITIONS : PatternTextFieldMapper.Defaults.FIELD_TYPE_DOCS, null, DelimiterAnalyzer.INSTANCE, DelimiterAnalyzer.INSTANCE), (Analyzer)DelimiterAnalyzer.INSTANCE, syntheticSource, false, Collections.emptyMap());
    }

    public String typeName() {
        return CONTENT_TYPE;
    }

    public String familyTypeName() {
        return "text";
    }

    public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
        return new ValueFetcher(){
            PatternTextCompositeValues docValues;

            public void setNextReader(LeafReaderContext context) {
                try {
                    this.docValues = PatternTextCompositeValues.from(context.reader(), PatternTextFieldType.this);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) throws IOException {
                if (!this.docValues.advanceExact(doc)) {
                    return List.of();
                }
                return List.of(this.docValues.binaryValue().utf8ToString());
            }

            public StoredFieldsSpec storedFieldsSpec() {
                return StoredFieldsSpec.NO_REQUIREMENTS;
            }
        };
    }

    private IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> getValueFetcherProvider(SearchExecutionContext searchExecutionContext) {
        if (this.disableTemplating) {
            return PatternTextFieldType.storedFieldFetcher(this.storedNamed());
        }
        return context -> {
            ValueFetcher valueFetcher = this.valueFetcher(searchExecutionContext, null);
            valueFetcher.setNextReader(context);
            return docID -> {
                try {
                    return valueFetcher.fetchValues(null, docID, new ArrayList());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
        };
    }

    private static IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> storedFieldFetcher(String name) {
        StoredFieldLoader loader = StoredFieldLoader.create((boolean)false, Set.of(name));
        return context -> {
            LeafStoredFieldLoader leafLoader = loader.getLoader(context, null);
            return docId -> {
                leafLoader.advanceTo(docId);
                Map storedFields = leafLoader.storedFields();
                return (List)storedFields.get(name);
            };
        };
    }

    private Query maybeSourceConfirmQuery(Query query, SearchExecutionContext context) {
        if (this.hasPositions) {
            return new ConstantScoreQuery(query);
        }
        return new ConstantScoreQuery((Query)new SourceConfirmedTextQuery(query, this.getValueFetcherProvider(context), this.indexAnalyzer));
    }

    private IntervalsSource toIntervalsSource(IntervalsSource source, Query approximation, SearchExecutionContext searchExecutionContext) {
        return new SourceIntervalsSource(source, approximation, this.getValueFetcherProvider(searchExecutionContext), this.indexAnalyzer);
    }

    public Query termQuery(Object query, SearchExecutionContext context) {
        return new ConstantScoreQuery(super.termQuery(query, context));
    }

    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, MultiTermQuery.RewriteMethod rewriteMethod) {
        return new ConstantScoreQuery(super.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, context, rewriteMethod));
    }

    public Query existsQuery(SearchExecutionContext context) {
        return new FieldExistsQuery(this.templateIdFieldName());
    }

    public IntervalsSource termIntervals(BytesRef term, SearchExecutionContext context) {
        return this.toIntervalsSource(Intervals.term((BytesRef)term), (Query)new TermQuery(new Term(this.name(), term)), context);
    }

    public IntervalsSource prefixIntervals(BytesRef term, SearchExecutionContext context) {
        return this.toIntervalsSource(Intervals.prefix((BytesRef)term, (int)IndexSearcher.getMaxClauseCount()), (Query)new PrefixQuery(new Term(this.name(), term)), context);
    }

    public IntervalsSource fuzzyIntervals(String term, int maxDistance, int prefixLength, boolean transpositions, SearchExecutionContext context) {
        FuzzyQuery fuzzyQuery = new FuzzyQuery(new Term(this.name(), term), maxDistance, prefixLength, IndexSearcher.getMaxClauseCount(), transpositions, MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE);
        IntervalsSource fuzzyIntervals = Intervals.multiterm((CompiledAutomaton)fuzzyQuery.getAutomata(), (int)IndexSearcher.getMaxClauseCount(), (String)term);
        return this.toIntervalsSource(fuzzyIntervals, (Query)fuzzyQuery, context);
    }

    public IntervalsSource wildcardIntervals(BytesRef pattern, SearchExecutionContext context) {
        return this.toIntervalsSource(Intervals.wildcard((BytesRef)pattern, (int)IndexSearcher.getMaxClauseCount()), (Query)new MatchAllDocsQuery(), context);
    }

    public IntervalsSource regexpIntervals(BytesRef pattern, SearchExecutionContext context) {
        return this.toIntervalsSource(Intervals.regexp((BytesRef)pattern, (int)IndexSearcher.getMaxClauseCount()), (Query)new MatchAllDocsQuery(), context);
    }

    public IntervalsSource rangeIntervals(BytesRef lowerTerm, BytesRef upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
        return this.toIntervalsSource(Intervals.range((BytesRef)lowerTerm, (BytesRef)upperTerm, (boolean)includeLower, (boolean)includeUpper, (int)IndexSearcher.getMaxClauseCount()), (Query)new MatchAllDocsQuery(), context);
    }

    public Query phraseQuery(TokenStream stream, int slop, boolean enablePosIncrements, SearchExecutionContext queryShardContext) throws IOException {
        Query textQuery = this.textFieldType.phraseQuery(stream, slop, enablePosIncrements, queryShardContext);
        return this.maybeSourceConfirmQuery(textQuery, queryShardContext);
    }

    public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext queryShardContext) throws IOException {
        Query textQuery = this.textFieldType.multiPhraseQuery(stream, slop, enablePositionIncrements, queryShardContext);
        return this.maybeSourceConfirmQuery(textQuery, queryShardContext);
    }

    public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, SearchExecutionContext queryShardContext) throws IOException {
        Query textQuery = this.textFieldType.phrasePrefixQuery(stream, slop, maxExpansions, queryShardContext);
        return this.maybeSourceConfirmQuery(textQuery, queryShardContext);
    }

    public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
        if (this.disableTemplating) {
            return new BlockStoredFieldsReader.BytesFromBytesRefsBlockLoader(this.storedNamed());
        }
        return new PatternTextBlockLoader(leafReader -> PatternTextCompositeValues.from(leafReader, this));
    }

    public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
        if (fieldDataContext.fielddataOperation() != MappedFieldType.FielddataOperation.SCRIPT) {
            throw new IllegalArgumentException("pattern_text fields do not support sorting and aggregations");
        }
        return new PatternTextIndexFieldData.Builder(this);
    }

    String templateFieldName() {
        return this.name() + TEMPLATE_SUFFIX;
    }

    String templateIdFieldName() {
        return this.name() + TEMPLATE_ID_SUFFIX;
    }

    String templateIdFieldName(String leafName) {
        return leafName + TEMPLATE_ID_SUFFIX;
    }

    String argsFieldName() {
        return this.name() + ARGS_SUFFIX;
    }

    String argsInfoFieldName() {
        return this.name() + ARGS_INFO_SUFFIX;
    }

    String storedNamed() {
        return this.name() + STORED_SUFFIX;
    }

    boolean disableTemplating() {
        return this.disableTemplating;
    }
}

