/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patterntext;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextDocValues;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextFieldType;

public final class PatternTextCompositeValues
extends BinaryDocValues {
    private final LeafStoredFieldLoader storedTemplateLoader;
    private final String storedMessageFieldName;
    private final BinaryDocValues patternTextDocValues;
    private final SortedSetDocValues templateIdDocValues;
    private boolean hasDocValue = false;

    PatternTextCompositeValues(LeafStoredFieldLoader storedTemplateLoader, String storedMessageFieldName, BinaryDocValues patternTextDocValues, SortedSetDocValues templateIdDocValues) {
        this.storedTemplateLoader = storedTemplateLoader;
        this.storedMessageFieldName = storedMessageFieldName;
        this.patternTextDocValues = patternTextDocValues;
        this.templateIdDocValues = templateIdDocValues;
    }

    static PatternTextCompositeValues from(LeafReader leafReader, PatternTextFieldType fieldType) throws IOException {
        SortedSetDocValues templateIdDocValues = DocValues.getSortedSet((LeafReader)leafReader, (String)fieldType.templateIdFieldName());
        if (templateIdDocValues.getValueCount() == 0L) {
            return null;
        }
        PatternTextDocValues docValues = PatternTextDocValues.from(leafReader, fieldType.templateFieldName(), fieldType.argsFieldName(), fieldType.argsInfoFieldName());
        StoredFieldLoader storedFieldLoader = StoredFieldLoader.create((boolean)false, Set.of(fieldType.storedNamed()));
        LeafStoredFieldLoader storedTemplateLoader = storedFieldLoader.getLoader(leafReader.getContext(), null);
        return new PatternTextCompositeValues(storedTemplateLoader, fieldType.storedNamed(), docValues, templateIdDocValues);
    }

    public BytesRef binaryValue() throws IOException {
        if (this.hasDocValue) {
            return this.patternTextDocValues.binaryValue();
        }
        Map storedFields = this.storedTemplateLoader.storedFields();
        List storedValues = (List)storedFields.get(this.storedMessageFieldName);
        assert (storedValues != null && storedValues.size() == 1 && storedValues.getFirst() instanceof BytesRef);
        return (BytesRef)storedValues.getFirst();
    }

    public int docID() {
        return this.templateIdDocValues.docID();
    }

    public boolean advanceExact(int i) throws IOException {
        boolean hasValue = this.templateIdDocValues.advanceExact(i);
        this.hasDocValue = this.patternTextDocValues.advanceExact(i);
        if (hasValue && !this.hasDocValue) {
            this.storedTemplateLoader.advanceTo(i);
        }
        return hasValue;
    }

    public int nextDoc() {
        throw new UnsupportedOperationException();
    }

    public int advance(int i) {
        throw new UnsupportedOperationException();
    }

    public long cost() {
        return this.templateIdDocValues.cost() + this.patternTextDocValues.cost();
    }
}

