/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai;

import java.util.concurrent.Flow;
import java.util.function.Function;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.xpack.core.inference.results.StreamingUnifiedChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.UnifiedChatCompletionException;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ChatCompletionErrorResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorParserContract;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorResponse;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventParser;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventProcessor;
import org.elasticsearch.xpack.inference.services.openai.OpenAiChatCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.openai.OpenAiUnifiedStreamingProcessor;

public class OpenAiUnifiedChatCompletionResponseHandler
extends OpenAiChatCompletionResponseHandler {
    private static final ChatCompletionErrorResponseHandler DEFAULT_CHAT_COMPLETION_ERROR_RESPONSE_HANDLER = new ChatCompletionErrorResponseHandler(UnifiedChatCompletionErrorResponse.ERROR_PARSER);
    private final ChatCompletionErrorResponseHandler chatCompletionErrorResponseHandler;

    public OpenAiUnifiedChatCompletionResponseHandler(String requestType, ResponseParser parseFunction) {
        this(requestType, parseFunction, UnifiedChatCompletionErrorResponse::fromHttpResult, DEFAULT_CHAT_COMPLETION_ERROR_RESPONSE_HANDLER);
    }

    public OpenAiUnifiedChatCompletionResponseHandler(String requestType, ResponseParser parseFunction, Function<HttpResult, ErrorResponse> errorParseFunction, UnifiedChatCompletionErrorParserContract unifiedChatCompletionErrorParser) {
        super(requestType, parseFunction, errorParseFunction);
        this.chatCompletionErrorResponseHandler = new ChatCompletionErrorResponseHandler(unifiedChatCompletionErrorParser);
    }

    private OpenAiUnifiedChatCompletionResponseHandler(String requestType, ResponseParser parseFunction, Function<HttpResult, ErrorResponse> errorParseFunction, ChatCompletionErrorResponseHandler chatCompletionErrorResponseHandler) {
        super(requestType, parseFunction, errorParseFunction);
        this.chatCompletionErrorResponseHandler = chatCompletionErrorResponseHandler;
    }

    @Override
    public InferenceServiceResults parseResult(Request request, Flow.Publisher<HttpResult> flow) {
        ServerSentEventProcessor serverSentEventProcessor = new ServerSentEventProcessor(new ServerSentEventParser());
        OpenAiUnifiedStreamingProcessor openAiProcessor = new OpenAiUnifiedStreamingProcessor((m, e) -> this.chatCompletionErrorResponseHandler.buildMidStreamChatCompletionError(request.getInferenceEntityId(), (String)m, (Exception)e));
        flow.subscribe(serverSentEventProcessor);
        serverSentEventProcessor.subscribe(openAiProcessor);
        return new StreamingUnifiedChatCompletionResults((Flow.Publisher)openAiProcessor);
    }

    protected UnifiedChatCompletionException buildError(String message, Request request, HttpResult result) {
        return this.chatCompletionErrorResponseHandler.buildChatCompletionError(message, request, result);
    }

    public static UnifiedChatCompletionException buildMidStreamError(String inferenceEntityId, String message, Exception e) {
        return DEFAULT_CHAT_COMPLETION_ERROR_RESPONSE_HANDLER.buildMidStreamChatCompletionError(inferenceEntityId, message, e);
    }
}

