/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.mistral;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;
import org.elasticsearch.xpack.inference.services.mistral.action.MistralActionVisitor;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class MistralModel
extends RateLimitGroupingModel {
    protected URI uri;
    protected RateLimitSettings rateLimitSettings;

    protected MistralModel(ModelConfigurations configurations, ModelSecrets secrets) {
        super(configurations, secrets);
    }

    protected MistralModel(RateLimitGroupingModel model, ServiceSettings serviceSettings) {
        super(model, serviceSettings);
    }

    public URI uri() {
        return this.uri;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    @Override
    public int rateLimitGroupingHash() {
        return Objects.hash(this.getServiceSettings().modelId(), this.getSecretSettings().apiKey());
    }

    public void setURI(String newUri) {
        try {
            this.uri = new URI(newUri);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    public abstract ExecutableAction accept(MistralActionVisitor var1);
}

