/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.jinaai.embeddings;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;

public enum JinaAIEmbeddingType {
    FLOAT(DenseVectorFieldMapper.ElementType.FLOAT, "float"),
    BIT(DenseVectorFieldMapper.ElementType.BIT, "binary"),
    BINARY(DenseVectorFieldMapper.ElementType.BIT, "binary");

    private static final Map<DenseVectorFieldMapper.ElementType, JinaAIEmbeddingType> ELEMENT_TYPE_TO_JINA_AI_EMBEDDING;
    static final EnumSet<DenseVectorFieldMapper.ElementType> SUPPORTED_ELEMENT_TYPES;
    private static final TransportVersion JINA_AI_EMBEDDING_TYPE_SUPPORT_ADDED;
    private final DenseVectorFieldMapper.ElementType elementType;
    private final String requestString;

    private JinaAIEmbeddingType(DenseVectorFieldMapper.ElementType elementType, String requestString) {
        this.elementType = elementType;
        this.requestString = requestString;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String toRequestString() {
        return this.requestString;
    }

    public static String toLowerCase(JinaAIEmbeddingType type) {
        return type.toString().toLowerCase(Locale.ROOT);
    }

    public static JinaAIEmbeddingType fromString(String name) {
        return JinaAIEmbeddingType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static JinaAIEmbeddingType fromElementType(DenseVectorFieldMapper.ElementType elementType) {
        JinaAIEmbeddingType embedding = ELEMENT_TYPE_TO_JINA_AI_EMBEDDING.get(elementType);
        if (embedding == null) {
            Object[] validElementTypes = (String[])SUPPORTED_ELEMENT_TYPES.stream().map(value -> value.toString().toLowerCase(Locale.ROOT)).toArray(String[]::new);
            Arrays.sort(validElementTypes);
            throw new IllegalArgumentException(Strings.format((String)"Element type [%s] does not map to a Jina AI embedding value, must be one of [%s]", (Object[])new Object[]{elementType, String.join((CharSequence)", ", (CharSequence[])validElementTypes)}));
        }
        return embedding;
    }

    public DenseVectorFieldMapper.ElementType toElementType() {
        return this.elementType;
    }

    public static JinaAIEmbeddingType translateToVersion(JinaAIEmbeddingType embeddingType, TransportVersion version) {
        if (version.supports(JINA_AI_EMBEDDING_TYPE_SUPPORT_ADDED)) {
            return embeddingType;
        }
        return FLOAT;
    }

    static {
        ELEMENT_TYPE_TO_JINA_AI_EMBEDDING = Map.of(DenseVectorFieldMapper.ElementType.FLOAT, FLOAT, DenseVectorFieldMapper.ElementType.BIT, BIT);
        SUPPORTED_ELEMENT_TYPES = EnumSet.copyOf(ELEMENT_TYPE_TO_JINA_AI_EMBEDDING.keySet());
        JINA_AI_EMBEDDING_TYPE_SUPPORT_ADDED = TransportVersion.fromName((String)"jina_ai_embedding_type_support_added");
    }

    private static final class RequestConstants {
        private static final String FLOAT = "float";
        private static final String BIT = "binary";

        private RequestConstants() {
        }
    }
}

