/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.jinaai;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.jinaai.JinaAIModel;

public record JinaAIAccount(URI uri, SecureString apiKey) {
    public JinaAIAccount {
        Objects.requireNonNull(uri);
        Objects.requireNonNull(apiKey);
    }

    public static JinaAIAccount of(JinaAIModel model, CheckedSupplier<URI, URISyntaxException> uriBuilder) {
        URI uri = RequestUtils.buildUri(model.uri(), "JinaAI", uriBuilder);
        return new JinaAIAccount(uri, model.apiKey());
    }
}

