/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface;

import java.io.IOException;
import java.util.Optional;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorParserContract;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorResponseUtils;
import org.elasticsearch.xpack.inference.services.huggingface.response.HuggingFaceErrorResponseEntity;
import org.elasticsearch.xpack.inference.services.openai.OpenAiUnifiedChatCompletionResponseHandler;

public class HuggingFaceChatCompletionResponseHandler
extends OpenAiUnifiedChatCompletionResponseHandler {
    private static final String HUGGING_FACE_ERROR = "hugging_face_error";
    private static final UnifiedChatCompletionErrorParserContract HUGGING_FACE_ERROR_PARSER = UnifiedChatCompletionErrorResponseUtils.createErrorParserWithObjectParser(StreamingHuggingFaceErrorResponseEntity.ERROR_PARSER);

    public HuggingFaceChatCompletionResponseHandler(String requestType, ResponseParser parseFunction) {
        super(requestType, parseFunction, HuggingFaceErrorResponseEntity::fromResponse, HUGGING_FACE_ERROR_PARSER);
    }

    private static ErrorField parseErrorField(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return ErrorField.parseString(parser);
        }
        if (token == XContentParser.Token.START_OBJECT) {
            return ErrorField.parseObject(parser);
        }
        if (token == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        throw new XContentParseException("Unexpected token: " + String.valueOf(token));
    }

    private record ErrorField(String message, @Nullable Integer httpStatusCode) {
        private static final ConstructingObjectParser<ErrorField, Void> PARSER = new ConstructingObjectParser(ErrorField.class.getSimpleName(), true, args -> new ErrorField(args[0] != null ? (String)args[0] : "unknown", (Integer)args[1]));

        public static ErrorField parseObject(XContentParser parser) {
            return (ErrorField)PARSER.apply(parser, null);
        }

        public static ErrorField parseString(XContentParser parser) throws IOException {
            return new ErrorField(parser.text(), null);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("message", new String[0]));
            PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), new ParseField("http_status_code", new String[0]));
        }
    }

    private static class StreamingHuggingFaceErrorResponseEntity
    extends UnifiedChatCompletionErrorResponse {
        private static final ConstructingObjectParser<Optional<UnifiedChatCompletionErrorResponse>, Void> ERROR_PARSER = new ConstructingObjectParser("hugging_face_error", true, args -> {
            if (args[0] == null) {
                return Optional.empty();
            }
            return Optional.of(new StreamingHuggingFaceErrorResponseEntity((ErrorField)args[0]));
        });

        StreamingHuggingFaceErrorResponseEntity(ErrorField errorField) {
            super(errorField.message, HuggingFaceChatCompletionResponseHandler.HUGGING_FACE_ERROR, errorField.httpStatusCode != null ? String.valueOf(errorField.httpStatusCode) : null, null);
        }

        static {
            ERROR_PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> HuggingFaceChatCompletionResponseHandler.parseErrorField(p), new ParseField("error", new String[0]), ObjectParser.ValueType.VALUE_OBJECT_ARRAY);
        }
    }
}

