/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic;

import java.util.Objects;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.sender.BaseRequestManager;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceModel;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRequest;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRequestMetadata;

public abstract class ElasticInferenceServiceRequestManager
extends BaseRequestManager {
    private final ElasticInferenceServiceRequestMetadata requestMetadata;

    protected ElasticInferenceServiceRequestManager(ThreadPool threadPool, ElasticInferenceServiceModel model) {
        super(threadPool, model.getInferenceEntityId(), RateLimitGrouping.of(model), model.rateLimitSettings());
        this.requestMetadata = ElasticInferenceServiceRequest.extractRequestMetadataFromThreadContext(threadPool.getThreadContext());
    }

    public ElasticInferenceServiceRequestMetadata requestMetadata() {
        return this.requestMetadata;
    }

    record RateLimitGrouping(int modelIdHash) {
        public static RateLimitGrouping of(ElasticInferenceServiceModel model) {
            Objects.requireNonNull(model);
            return new RateLimitGrouping(model.rateLimitGroupingHash());
        }
    }
}

