/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public record QueryParameters(List<Parameter> parameters) implements ToXContentFragment,
Writeable
{
    public static final QueryParameters EMPTY = new QueryParameters(List.of());
    public static final String QUERY_PARAMETERS = "query_parameters";

    public QueryParameters {
        Objects.requireNonNull(parameters);
    }

    public QueryParameters(StreamInput in) throws IOException {
        this(in.readCollectionAsImmutableList(Parameter::new));
    }

    public static QueryParameters fromMap(Map<String, Object> map, ValidationException validationException) {
        List<Tuple<String, String>> queryParams = ServiceUtils.extractOptionalListOfStringTuples(map, QUERY_PARAMETERS, "service_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return QueryParameters.fromTuples(queryParams);
    }

    private static QueryParameters fromTuples(List<Tuple<String, String>> queryParams) {
        if (queryParams == null) {
            return EMPTY;
        }
        return new QueryParameters(queryParams.stream().map(tuple -> new Parameter((String)tuple.v1(), (String)tuple.v2())).toList());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.parameters);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (!this.parameters.isEmpty()) {
            builder.startArray(QUERY_PARAMETERS);
            for (Parameter parameter : this.parameters) {
                parameter.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder;
    }

    public record Parameter(String key, String value) implements ToXContentFragment,
    Writeable
    {
        public Parameter {
            Objects.requireNonNull(key);
            Objects.requireNonNull(value);
        }

        public Parameter(StreamInput in) throws IOException {
            this(in.readString(), in.readString());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.key);
            out.writeString(this.value);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray();
            builder.value(this.key);
            builder.value(this.value);
            builder.endArray();
            return builder;
        }
    }
}

