/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class InputTypeTranslator
implements ToXContentFragment,
Writeable {
    public static final String INPUT_TYPE_TRANSLATOR = "input_type";
    public static final String TRANSLATION = "translation";
    public static final String DEFAULT = "default";
    public static final InputTypeTranslator EMPTY_TRANSLATOR = new InputTypeTranslator(null, null);
    private final Map<InputType, String> inputTypeTranslation;
    private final String defaultValue;

    public static InputTypeTranslator fromMap(Map<String, Object> map, ValidationException validationException, String serviceName) {
        if (map == null || map.isEmpty()) {
            return EMPTY_TRANSLATOR;
        }
        Map inputTypeTranslation = Objects.requireNonNullElse(ServiceUtils.extractOptionalMap(map, INPUT_TYPE_TRANSLATOR, validationException), new HashMap(Map.of()));
        Map<String, Object> translationMap = ServiceUtils.extractOptionalMap(inputTypeTranslation, TRANSLATION, validationException);
        Map validatedTranslation = InputType.validateInputTypeTranslationValues(translationMap, (ValidationException)validationException);
        String defaultValue = ServiceUtils.extractOptionalEmptyString(inputTypeTranslation, DEFAULT, validationException);
        ServiceUtils.throwIfNotEmptyMap(inputTypeTranslation, INPUT_TYPE_TRANSLATOR, "input_type_translator");
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new InputTypeTranslator(validatedTranslation, defaultValue);
    }

    public InputTypeTranslator(@Nullable Map<InputType, String> inputTypeTranslation, @Nullable String defaultValue) {
        this.inputTypeTranslation = Objects.requireNonNullElse(inputTypeTranslation, Map.of());
        this.defaultValue = Objects.requireNonNullElse(defaultValue, "");
    }

    public InputTypeTranslator(StreamInput in) throws IOException {
        this.inputTypeTranslation = in.readImmutableMap(keyReader -> (InputType)keyReader.readEnum(InputType.class), StreamInput::readString);
        this.defaultValue = in.readString();
    }

    public Map<InputType, String> getTranslation() {
        return this.inputTypeTranslation;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        TreeMap<InputType, String> sortedMap = new TreeMap<InputType, String>(this.inputTypeTranslation);
        builder.startObject(INPUT_TYPE_TRANSLATOR);
        builder.startObject(TRANSLATION);
        for (Map.Entry<InputType, String> entry : sortedMap.entrySet()) {
            builder.field(entry.getKey().toString(), entry.getValue());
        }
        builder.endObject();
        builder.field(DEFAULT, this.defaultValue);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.inputTypeTranslation, StreamOutput::writeEnum, StreamOutput::writeString);
        out.writeString(this.defaultValue);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputTypeTranslator that = (InputTypeTranslator)o;
        return Objects.equals(this.inputTypeTranslation, that.inputTypeTranslation) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.inputTypeTranslation, this.defaultValue);
    }
}

