/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.contextualai;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.services.RateLimitGroupingModel;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.contextualai.ContextualAiRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.contextualai.action.ContextualAiActionVisitor;
import org.elasticsearch.xpack.inference.services.settings.ApiKeySecrets;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public abstract class ContextualAiModel
extends RateLimitGroupingModel {
    private final SecureString apiKey;
    private final ContextualAiRateLimitServiceSettings rateLimitServiceSettings;

    public ContextualAiModel(ModelConfigurations configurations, ModelSecrets secrets, @Nullable ApiKeySecrets apiKeySecrets, ContextualAiRateLimitServiceSettings rateLimitServiceSettings) {
        super(configurations, secrets);
        this.rateLimitServiceSettings = Objects.requireNonNull(rateLimitServiceSettings);
        this.apiKey = ServiceUtils.apiKey(apiKeySecrets);
    }

    protected ContextualAiModel(ContextualAiModel model, TaskSettings taskSettings) {
        super((RateLimitGroupingModel)model, taskSettings);
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
        this.apiKey = model.apiKey();
    }

    protected ContextualAiModel(ContextualAiModel model, ServiceSettings serviceSettings) {
        super((RateLimitGroupingModel)model, serviceSettings);
        this.rateLimitServiceSettings = model.rateLimitServiceSettings();
        this.apiKey = model.apiKey();
    }

    public SecureString apiKey() {
        return this.apiKey;
    }

    public ContextualAiRateLimitServiceSettings rateLimitServiceSettings() {
        return this.rateLimitServiceSettings;
    }

    public abstract ExecutableAction accept(ContextualAiActionVisitor var1, Map<String, Object> var2);

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitServiceSettings.rateLimitSettings();
    }

    @Override
    public int rateLimitGroupingHash() {
        return this.apiKey().hashCode();
    }

    public URI baseUri() {
        return this.rateLimitServiceSettings.uri();
    }
}

