/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere.request.v1;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.cohere.CohereAccount;
import org.elasticsearch.xpack.inference.services.cohere.completion.CohereCompletionModel;
import org.elasticsearch.xpack.inference.services.cohere.request.CohereRequest;

public class CohereV1CompletionRequest
extends CohereRequest {
    private final List<String> input;

    public CohereV1CompletionRequest(List<String> input, CohereCompletionModel model, boolean stream) {
        super(CohereAccount.of(model), model.getInferenceEntityId(), model.getServiceSettings().modelId(), stream);
        this.input = Objects.requireNonNull(input);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("message", this.input.getFirst());
        if (this.getModelId() != null) {
            builder.field("model", this.getModelId());
        }
        if (this.isStreaming()) {
            builder.field("stream", true);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected List<String> pathSegments() {
        return List.of("v1", "chat");
    }
}

