/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.cohere;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.services.cohere.CohereModel;

public record CohereAccount(URI baseUri, SecureString apiKey) {
    public CohereAccount {
        Objects.requireNonNull(baseUri);
        Objects.requireNonNull(apiKey);
    }

    public static CohereAccount of(CohereModel model) {
        try {
            URI uri = model.baseUri() != null ? model.baseUri() : new URIBuilder().setScheme("https").setHost("api.cohere.ai").build();
            return new CohereAccount(uri, model.apiKey());
        }
        catch (URISyntaxException e) {
            throw new ElasticsearchStatusException(Strings.format((String)"Failed to construct %s URL", (Object[])new Object[]{"cohere"}), RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]);
        }
    }
}

