/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureopenai;

import org.apache.http.HttpResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandlerUtils;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseParser;
import org.elasticsearch.xpack.inference.external.http.retry.RetryException;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.openai.OpenAiResponseHandler;

public class AzureOpenAiResponseHandler
extends OpenAiResponseHandler {
    static final String REMAINING_REQUESTS = "x-ratelimit-remaining-requests";
    static final String REMAINING_TOKENS = "x-ratelimit-remaining-tokens";

    public AzureOpenAiResponseHandler(String requestType, ResponseParser parseFunction, boolean canHandleStreamingResponses) {
        super(requestType, parseFunction, canHandleStreamingResponses);
    }

    @Override
    protected RetryException buildExceptionHandling429(Request request, HttpResult result) {
        return new RetryException(true, this.buildError(AzureOpenAiResponseHandler.buildRateLimitErrorMessage(result), request, result));
    }

    static String buildRateLimitErrorMessage(HttpResult result) {
        HttpResponse response = result.response();
        String remainingTokens = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, REMAINING_TOKENS);
        String remainingRequests = ResponseHandlerUtils.getFirstHeaderOrUnknown(response, REMAINING_REQUESTS);
        String usageMessage = Strings.format((String)"Remaining tokens [%s]. Remaining requests [%s].", (Object[])new Object[]{remainingTokens, remainingRequests});
        return "Received a rate limit status code. " + usageMessage;
    }
}

