/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.azureaistudio.rerank;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioEndpointType;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioProvider;
import org.elasticsearch.xpack.inference.services.azureaistudio.AzureAiStudioServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class AzureAiStudioRerankServiceSettings
extends AzureAiStudioServiceSettings {
    public static final String NAME = "azure_ai_studio_rerank_service_settings";
    private static final TransportVersion ML_INFERENCE_AZURE_AI_STUDIO_RERANK_ADDED = TransportVersion.fromName((String)"ml_inference_azure_ai_studio_rerank_added");

    public static AzureAiStudioRerankServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        AzureAiStudioRerankCommonFields settings = AzureAiStudioRerankServiceSettings.rerankSettingsFromMap(map, validationException, context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new AzureAiStudioRerankServiceSettings(settings);
    }

    private static AzureAiStudioRerankCommonFields rerankSettingsFromMap(Map<String, Object> map, ValidationException validationException, ConfigurationParseContext context) {
        AzureAiStudioServiceSettings.BaseAzureAiStudioCommonFields baseSettings = AzureAiStudioServiceSettings.fromMap(map, validationException, context);
        return new AzureAiStudioRerankCommonFields(baseSettings);
    }

    public AzureAiStudioRerankServiceSettings(String target, AzureAiStudioProvider provider, AzureAiStudioEndpointType endpointType, @Nullable RateLimitSettings rateLimitSettings) {
        super(target, provider, endpointType, rateLimitSettings);
    }

    public AzureAiStudioRerankServiceSettings(StreamInput in) throws IOException {
        super(in);
    }

    private AzureAiStudioRerankServiceSettings(AzureAiStudioRerankCommonFields fields) {
        this(fields.baseCommonFields.target(), fields.baseCommonFields.provider(), fields.baseCommonFields.endpointType(), fields.baseCommonFields.rateLimitSettings());
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return ML_INFERENCE_AZURE_AI_STUDIO_RERANK_ADDED;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        super.addXContentFields(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.addExposedXContentFields(builder, params);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureAiStudioRerankServiceSettings that = (AzureAiStudioRerankServiceSettings)o;
        return Objects.equals(this.target, that.target) && Objects.equals((Object)this.provider, (Object)that.provider) && Objects.equals((Object)this.endpointType, (Object)that.endpointType) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.target, this.provider, this.endpointType, this.rateLimitSettings});
    }

    private record AzureAiStudioRerankCommonFields(AzureAiStudioServiceSettings.BaseAzureAiStudioCommonFields baseCommonFields) {
    }
}

